package com.gingersoft.coldchain_module.di.module;

import com.gingersoft.coldchain_module.mvp.contract.SupplementOrderContract;
import com.gingersoft.coldchain_module.mvp.model.SupplementOrderModel;
import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;


@Module
public class SupplementOrderModule {
    private SupplementOrderContract.View view;

    /**
     * 构建SupplementOrderModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public SupplementOrderModule(SupplementOrderContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    SupplementOrderContract.View provideSupplementOrderView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    SupplementOrderContract.Model provideSupplementOrderModel(SupplementOrderModel model) {
        return model;
    }
}