package com.joe.print;

import android.content.Intent;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCResult;
import com.billy.cc.core.component.CCUtil;
import com.billy.cc.core.component.IComponent;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.joe.print.mvp.print.printerManger.PrjPtinterManager;
import com.joe.print.mvp.print.service.PrjService;
import com.joe.print.mvp.ui.activity.PrintActivity;
import com.joe.print.mvp.ui.activity.PrinterListActivity;


public class PrintComponent implements IComponent {


    @Override
    public String getName() {
        //组件的名称，调用此组件的方式：
        // CC.obtainBuilder("ComponentA")...build().callAsync()
        return ComponentName.COMPONENT_PRINT;
    }

    /**
     * 组件被调用时的入口
     * 要确保每个逻辑分支都会调用到CC.sendCCResult，
     * 包括try-catch,if-else,switch-case-default,startActivity
     *
     * @param cc 组件调用对象，可从此对象中获取相关信息
     * @return true:将异步调用CC.sendCCResult(...),用于异步实现相关功能，例如：文件加载、网络请求等
     * false:会同步调用CC.sendCCResult(...),即在onCall方法return之前调用，否则将被视为不合法的实现
     */
    @Override
    public boolean onCall(CC cc) {
        String actionName = cc.getActionName();
        switch (actionName) {
            case "killPrintActivity":

                break;
            case "showPrintActivity":
                openActivity(cc);
                break;
            case "getLifecycleFragment":
                //demo for provide fragment object to other component
                getLifecycleFragment(cc);
                break;
            case "lifecycleFragment.addText":
                lifecycleFragmentDoubleText(cc);
                break;
            case "getInfo":
                getInfo(cc);
                break;
            case "printActivity":
                return print(cc);
            case "openPrintService":
                //打開打印服務
                Intent intent = new Intent(cc.getContext(), PrjService.class);
                cc.getContext().startService(intent);
                CC.sendCCResult(cc.getCallId(), CCResult.success());
                break;
            case "stopPrintService":
                cc.getContext().stopService(new Intent(cc.getContext(), PrjService.class));
                CC.sendCCResult(cc.getCallId(), CCResult.success());
                break;
            case "getPrjData":
                PrjPtinterManager.getInstance(cc.getContext()).initUsbPrint();
                PrjPtinterManager.getInstance(cc.getContext()).getPrjInfo();
                break;
            default:
//                cc.callAsync(new IComponentCallback() {
//                    @Override
//                    public void onResult(CC cc, CCResult result) {
//                    }
//                });
                //这个逻辑分支上没有调用CC.sendCCResult(...),是一种错误的示例
                //并且方法的返回值为false，代表不会异步调用CC.sendCCResult(...)
                //在LocalCCInterceptor中将会返回错误码为-10的CCResult
                break;
        }
        return false;
    }

    private void lifecycleFragmentDoubleText(CC cc) {
//        LifecycleFragment lifecycleFragment = cc.getParamItem("fragment");
//        if (lifecycleFragment != null) {
//            String text = cc.getParamItem("text", "");
//            lifecycleFragment.addText(text);
//            CC.sendCCResult(cc.getCallId(), CCResult.success());
//        } else {
//            CC.sendCCResult(cc.getCallId(), CCResult.error("no fragment params"));
//        }
    }

    private void getLifecycleFragment(CC cc) {
//        CC.sendCCResult(cc.getCallId(), CCResult.successWithNoKey(new LifecycleFragment()));
    }

    private void getInfo(CC cc) {
        String userName = "billy";
        CC.sendCCResult(cc.getCallId(), CCResult.success("userName", userName));
    }

    private void openActivity(CC cc) {
        CCUtil.navigateTo(cc, PrinterListActivity.class);
        CC.sendCCResult(cc.getCallId(), CCResult.success());
    }

    private boolean print(CC cc) {
//        Context context = cc.getContext();
//        Intent intent = new Intent(context, PrintActivity.class);
//        if (!(context instanceof Activity)) {
//            //调用方没有设置context或app间组件跳转，context为application
//            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//        }
//        //将cc的callId传给Activity，登录完成后通过这个callId来回传结果
//        intent.putExtra("callId", cc.getCallId());
//        context.startActivity(intent);
        CCUtil.navigateTo(cc, PrintActivity.class);
        //返回true，不立即调用CC.sendCCResult
        return true;
    }

}
