package com.joe.print.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.google.gson.Gson;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.joe.print.mvp.contract.IpPrintListActivityContract;
import com.joe.print.mvp.model.server.PrintInfoService;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@FragmentScope
public class IpPrintListActivityModel extends BaseModel implements IpPrintListActivityContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public IpPrintListActivityModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getPrinterList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(PrintInfoService.class)
                .getPrinterList(restaurantId);
    }

    @Override
    public Observable<BaseResult> deletePrinter(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(PrintInfoService.class)
                .deletePrinterList(requestBody);
    }

    @Override
    public Observable<BaseResult> getPrintModel(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(PrintInfoService.class)
                .getPrinterModelList(restaurantId);
    }
}