package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;
import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-08
 * 修订历史：2020-04-08
 * 描述：
 */
@Data
@Entity
public class Discount {

    /**
     * ID
     */
    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private int restaurant_id;
    /**
     * 金額
     */
    private double amount;
    /**
     * 折扣
     */
    private double discount_value;
    /**
     * 类型#0:金额;1:折扣;
     */
    private int type;
    /**
     * 折扣可使用范围#0:食品;1:账单;
     */
    private String discountType;
    /**
     * 状态#0:启用;1:禁用;
     */
    private int status;
    /**
     * 折扣描述
     */
    private String remark;
    private String begin_time;
    private String end_time;


    /**
     * 自定義字段
     */
    @Transient
    private long memberId = -1;


    @Generated(hash = 901376651)
    public Discount(Long id, int restaurant_id, double amount, double discount_value,
                    int type, String discountType, int status, String remark, String begin_time,
                    String end_time) {
        this.id = id;
        this.restaurant_id = restaurant_id;
        this.amount = amount;
        this.discount_value = discount_value;
        this.type = type;
        this.discountType = discountType;
        this.status = status;
        this.remark = remark;
        this.begin_time = begin_time;
        this.end_time = end_time;
    }


    @Generated(hash = 1777606421)
    public Discount() {
    }

    public long getMemberId() {
        return memberId;
    }

    public void setMemberId(long memberId) {
        this.memberId = memberId;
    }


    public Long getId() {
        return this.id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    public int getRestaurant_id() {
        return this.restaurant_id;
    }


    public void setRestaurant_id(int restaurant_id) {
        this.restaurant_id = restaurant_id;
    }


    public double getAmount() {
        return this.amount;
    }


    public void setAmount(double amount) {
        this.amount = amount;
    }


    public double getDiscount_value() {
        return this.discount_value;
    }


    public void setDiscount_value(double discount_value) {
        this.discount_value = discount_value;
    }


    public int getType() {
        return this.type;
    }


    public void setType(int type) {
        this.type = type;
    }


    public String getDiscountType() {
        return this.discountType;
    }


    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }


    public int getStatus() {
        return this.status;
    }


    public void setStatus(int status) {
        this.status = status;
    }


    public String getRemark() {
        return this.remark;
    }


    public void setRemark(String remark) {
        this.remark = remark;
    }


    public String getBegin_time() {
        return this.begin_time;
    }


    public void setBegin_time(String begin_time) {
        this.begin_time = begin_time;
    }


    public String getEnd_time() {
        return this.end_time;
    }


    public void setEnd_time(String end_time) {
        this.end_time = end_time;
    }


}
