package com.gingersoft.gsa.cloud.base.order.cart;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.bean.discount.CouponDiscountBean;
import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.base.order.commodity.Commodity;
import com.gingersoft.gsa.cloud.base.order.commodity.MealCommodity;
import com.gingersoft.gsa.cloud.base.order.commodity.MealTakeaway;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.discount.CouponDiscount;
import com.gingersoft.gsa.cloud.base.order.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.base.order.discount.MultyDiscount;
import com.gingersoft.gsa.cloud.base.order.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.constans.FoodSummaryConstans;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.jess.arms.utils.Preconditions;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 購物車
 */
@Setter
@Getter
public class ShoppingCart {

    private static ShoppingCart shoppingCart;

    public static ShoppingCart getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new ShoppingCart();
        }
        return shoppingCart;
    }

    /**
     * 商品列表
     */
    protected List<OrderDetail> orderCommodityList = new ArrayList<>();
    /**
     * 賬單項列表
     */
    protected List<BillItem> billItemList = new ArrayList<>();
    /**
     * 折扣列表
     *
     * @see NomalDiscount
     * @see MemberDiscount
     * @see CouponDiscount
     */
    protected List<MultyDiscount> multyDiscountList = new ArrayList<>();
    /**
     * 服務費
     */
    protected Double serviceCharge;
    /**
     * 賬單小數
     */
    protected Double rounding;
    /**
     * 合計
     */
    protected double wholeAmount = 0.0;
    /**
     * 總金額
     */
    protected double totalAmount = 0.0;


    /**
     * 將商品添加到購物車
     *
     * @param commodityList
     */
    public void addCommodityList(List<OrderDetail> commodityList) {
        getOrderCommodityList().addAll(commodityList);
    }

    /**
     * 將商品添加到購物車
     *
     * @param commodity
     */
    public void addCommodity(OrderDetail commodity) {
        getOrderCommodityList().add(commodity);
    }

    /**
     * 將商品移出購物車
     *
     * @param commodity
     */
    public void delCommodity(OrderDetail commodity) {
        getOrderCommodityList().remove(commodity);
    }

    /**
     * 修改商品數量
     *
     * @param commodity
     */
//    public void setCommodityNum(Commodity commodity, int number) {
//        for (Commodity c : orderCommodityList) {
//            if (c == commodity) {
//                c.setNumber(number);
//                break;
//            }
//        }
//    }

    /**
     * 添加賬單項
     *
     * @param billItem
     */
    public void addBillItem(BillItem billItem) {
        getBillItemList().add(billItem);
    }

    /**
     * 添加賬單項
     *
     * @param billItems
     */
    public void addBillItems(List<BillItem> billItems) {
        getBillItemList().addAll(billItems);
    }

    /**
     * 刪除張單項
     *
     * @param billItem
     */
    public void delBillItem(BillItem billItem) {
        getBillItemList().remove(billItem);
    }

    /**
     * 添加折扣
     *
     * @param multyDiscount
     */
    public void addMultyDiscount(MultyDiscount multyDiscount) {
        getMultyDiscountList().add(multyDiscount);
    }

    /**
     * 刪除折扣
     *
     * @param multyDiscount
     */
    public void delMultyDiscount(MultyDiscount multyDiscount) {
        getMultyDiscountList().remove(multyDiscount);
    }

    /**
     * 將普通折扣添加到鏈條中
     *
     * @param discount
     * @return
     */
    public MultyDiscount addNomalDiscount(MultyDiscount multyDiscounts, Discount discount) {
        MultyDiscount nomalDiscount = new NomalDiscount(discount.getRemark(), multyDiscounts, discount);
        return nomalDiscount;
    }

    /**
     * 將會員等級折扣添加到鏈條中
     *
     * @param discount
     * @return
     */
    public MultyDiscount addMemberDiscount(MultyDiscount multyDiscounts, MemberInfo discount) {
        MultyDiscount memberDiscount = new MemberDiscount(discount.getMemberName(), multyDiscounts, discount);
        return memberDiscount;
    }

    /**
     * 將優惠券折扣添加到鏈條中
     *
     * @param discount
     * @return
     */
    public MultyDiscount addCouponDiscount(MultyDiscount multyDiscounts, CouponDiscountBean discount) {
        MultyDiscount couponDiscount = new CouponDiscount(discount.getName(), multyDiscounts, discount);
        return couponDiscount;
    }


    public MultyDiscount createNomalDiscount(Discount discount) {
        MultyDiscount nomalDiscount = new NomalDiscount(discount.getRemark(), null, discount);
        return nomalDiscount;
    }

    public MultyDiscount createMemberDiscount(MemberInfo discount) {
        MultyDiscount memberDiscount = new MemberDiscount(discount.getMemberName(), null, discount);
        return memberDiscount;
    }

    public MultyDiscount createCouponDiscount(CouponDiscountBean discount) {
        MultyDiscount couponDiscount = new CouponDiscount(discount.getName(), null, discount);
        return couponDiscount;
    }

    /**
     * 計算折扣鏈金額
     */
    public double calculateLinkedDiscounts(double money) {
        MultyDiscount multyDiscounts = null;
        for (int i = multyDiscountList.size() - 1; i >= 0; i--) {
            MultyDiscount discount = multyDiscountList.get(i);
            if (discount instanceof NomalDiscount) {
                multyDiscounts = addNomalDiscount(multyDiscounts, ((NomalDiscount) discount).getDiscount());
            } else if (discount instanceof MemberDiscount) {
                multyDiscounts = addMemberDiscount(multyDiscounts, ((MemberDiscount) discount).getMemberDiscount());
            } else if (discount instanceof CouponDiscount) {
                multyDiscounts = addCouponDiscount(multyDiscounts, ((CouponDiscount) discount).getCouponDiscount());
            }
        }
        if (multyDiscounts != null) {
            money = multyDiscounts.calculate(money);
        }
        return money;
    }

    private void updateBillItemList() {


    }

    public List<OrderDetail> getOrderCommodityList() {
        if (orderCommodityList == null) {
            orderCommodityList = new ArrayList<>();
        }
        return orderCommodityList;
    }

    public List<BillItem> getBillItemList() {
        if (billItemList == null) {
            billItemList = new ArrayList<>();
        }
        return billItemList;
    }

    public List<MultyDiscount> getMultyDiscountList() {
        if (multyDiscountList == null) {
            multyDiscountList = new ArrayList<>();
        }
        return multyDiscountList;
    }

    public static void main(String[] args) {

        MultyDiscount multyDiscounts = null;
        ShoppingCart shoppingCart = new ShoppingCart();

        Discount discount = new Discount();
        discount.setRemark("9折");
        discount.setType(1);
        discount.setDiscount_value(10);
        multyDiscounts = shoppingCart.addNomalDiscount(multyDiscounts, discount);
        shoppingCart.addMultyDiscount(multyDiscounts);

        CouponDiscountBean couponDiscountBean = new CouponDiscountBean();
        couponDiscountBean.setCouponTypeName1("魚屋立減50元券");
        couponDiscountBean.setAmount(50);
        couponDiscountBean.setCouponType((byte) 2);
        multyDiscounts = shoppingCart.addCouponDiscount(multyDiscounts, couponDiscountBean);
        shoppingCart.addMultyDiscount(multyDiscounts);

        MemberInfo memberInfo2 = new MemberInfo();
        memberInfo2.setMemberName("白金會員20%");
        memberInfo2.setMemberDiscount(20);
        multyDiscounts = shoppingCart.addMemberDiscount(multyDiscounts, memberInfo2);
        shoppingCart.addMultyDiscount(multyDiscounts);

        double discountAfterMoney = shoppingCart.calculateLinkedDiscounts(200);

        System.out.println("折扣後的金額：" + discountAfterMoney);
    }

    /**
     * 具體支付類需要實現的方法
     */
    public void pay(double money) {

    }


    public void initialization() {
        if (orderCommodityList != null) {
            orderCommodityList.clear();
//            orderCommodityList = null;
        }
        if (billItemList != null) {
            billItemList.clear();
//            billItemList = null;
        }
        if (multyDiscountList != null) {
            multyDiscountList.clear();
//            multyDiscountList = null;
        }
        serviceCharge = null;
        rounding = null;
        wholeAmount = 0.0;
        totalAmount = 0.0;
    }


}
