package com.gingersoft.gsa.cloud.base.order.order;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.Member;
import com.gingersoft.gsa.cloud.base.order.bean.DeleteOrderRequest;
import com.gingersoft.gsa.cloud.base.order.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * @作者: bin
 * @創建時間: 2020-10-14
 * @更新時間: 2020-10-14
 * @描述: 堂食訂單
 */
@Getter
@Setter
public class DoshokuOrder extends BaseOrder implements Member {

    private static DoshokuOrder doshokuOrder;

    public static DoshokuOrder getInstance() {
        if (doshokuOrder == null) {
            doshokuOrder = new DoshokuOrder();
        }
        return doshokuOrder;
    }

    private DoshokuOrder() {
        super();
    }

    /**
     * 記錄刪除的食品以及原因
     */
    private List<DeleteOrderRequest> deleteMealOrders;
    /**
     * 已下單信息
     */
    private OrderBean orderPlaced;
    /**
     * 開台信息
     */
    private TableBean.DataBean openTableInfo;

    /**
     * 會員信息
     */
    private MemberInfo memberInfo;


    /**
     * 是否需要更新會員信息(如開台有然後清除: "true:false" 這種情況需要重新送單更新會員信息)
     */
    private String memberUpdateStatus = true + "-" + true;
    /**
     * 記錄修改訂單操作
     * false#送單
     * true#修改訂單
     */
    private boolean modifyOrder = false;

    /**
     * 添加需要刪除的食品
     * @param request
     */
    public void addDeleteMealOrder(DeleteOrderRequest request){
        getDeleteMealOrders().add(request);
    }

    /**
     * 取消需要刪除的食品
     * @param request
     */
    public void delDeleteMealOrder(DeleteOrderRequest request){
        getDeleteMealOrders().remove(request);
    }

    public List<DeleteOrderRequest> getDeleteMealOrders() {
        if (deleteMealOrders == null) {
            deleteMealOrders = new ArrayList<>();
        }
        return deleteMealOrders;
    }

    @Override
    public void initialization() {
        if (deleteMealOrders != null) {
            deleteMealOrders.clear();
            deleteMealOrders = null;
        }
        if (orderPlaced != null) {
            orderPlaced = null;
        }
        if (openTableInfo != null) {
            openTableInfo = null;
        }
        if (memberInfo != null) {
            memberInfo = null;
        }
        memberUpdateStatus = null;
        modifyOrder = false;

        super.initialization();
    }
}
