package com.gingersoft.gsa.cloud.table.mvp.model.cart;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.bean.DeleteOrderRequest;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.bean.discount.CouponDiscountBean;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.CouponDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.MultyDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-24
 * 修订历史：2020-09-24
 * 描述：堂食下單購物車
 */
public class DoshokuCart extends ShoppingCart{

    /**
     * 食品列表
     */
    private List<OrderDetail> orderFoodList = new ArrayList<>();
    /**
     * 所有折扣實體
     */
    private MultyDiscount multyDiscounts;
    /**
     * 記錄刪除的食品以及原因
     */
    private List<DeleteOrderRequest> deleteOrders;
    /**
     * 服務費
     */
    private Double serviceCharge;


    public MultyDiscount addNomalDiscount(Discount discount) {
        multyDiscounts = new NomalDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    public MultyDiscount addMemberDiscount(MemberInfo discount) {
        multyDiscounts = new MemberDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    public MultyDiscount addCouponDiscount(CouponDiscountBean discount) {
        multyDiscounts = new CouponDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    @Override
    public void pay(double money) {
        super.pay(money);


    }
}
