package com.gingersoft.gsa.cloud.base.order.bean.discount;

import com.gingersoft.gsa.cloud.base.order.billItem.DiscountItem;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import java.io.Serializable;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-22
 * 修订历史：2020-09-22
 * 描述：
 */
public class OrderDiscount {

    public static final int ORDER_DISCOUNT = 0;
    public static final int MEMBER_DISCOUNT = 1;
    public static final int COUPON_DISCOUNT = 2;

    @Data
    public static class Request {

        /**
         * 0#整單折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**
         * 折扣ID
         */
        private Long discountId;
        /**
         * 會員折扣ID
         */
        private Long memberId;
        /**
         * 會員折扣比例
         */
        private Integer memberDiscountRate;
        /**
         * 折扣金額
         */
        private double discountAmount;
        /**
         * 是否计算服务费
         */
        private int scAble;

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Long getDiscountId() {
            return discountId;
        }

        public void setDiscountId(Long discountId) {
            this.discountId = discountId;
        }

        public Long getMemberId() {
            return memberId;
        }

        public void setMemberId(Long memberId) {
            this.memberId = memberId;
        }

        public Integer getMemberDiscountRate() {
            return memberDiscountRate;
        }

        public void setMemberDiscountRate(Integer memberDiscountRate) {
            this.memberDiscountRate = memberDiscountRate;
        }

        public double getDiscountAmount() {
            return discountAmount;
        }

        public void setDiscountAmount(double discountAmount) {
            this.discountAmount = discountAmount;
        }

        public int getScAble() {
            return scAble;
        }

        public void setScAble(int scAble) {
            this.scAble = scAble;
        }

        public static Request orderDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(ORDER_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setDiscountId(discount.getDiscount().getId());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }

        public static Request memberDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(MEMBER_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setMemberId(discount.getDiscount().getId());
                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }

        public static Request couponDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(COUPON_DISCOUNT);
            if(discount.getDiscount() != null) {
                request.setMemberId(discount.getDiscount().getMemberId());
                request.setDiscountId(discount.getDiscount().getId());
                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }
    }

    @Data
    public static class Respose implements Serializable {

        /**
         * 整單折扣ID
         */
        private Long discountId;
        /**折扣金額*/
        private double discountAmount;
        /**折扣比例*/
        private int discountValue;
        /**
         * 0#整單折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**折扣名称1*/
        private String remark;
        /**折扣名称2*/
        private String remark2;
        /**折扣名称3*/
        private String remark3;

        /**
         * 优惠券折扣相关
         */
        // 消費滿
        private Double spend;
        // 是否累計滿減：0否，1是
        private Byte accumulate;


        public String getRemark() {
            return remark;
        }

        public Long getDiscountId() {
            return discountId;
        }

        public void setDiscountId(Long discountId) {
            this.discountId = discountId;
        }

        public double getDiscountAmount() {
            return discountAmount;
        }

        public void setDiscountAmount(double discountAmount) {
            this.discountAmount = discountAmount;
        }

        public int getDiscountValue() {
            return discountValue;
        }

        public void setDiscountValue(int discountValue) {
            this.discountValue = discountValue;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getRemark2() {
            return remark2;
        }

        public void setRemark2(String remark2) {
            this.remark2 = remark2;
        }

        public String getRemark3() {
            return remark3;
        }

        public void setRemark3(String remark3) {
            this.remark3 = remark3;
        }

        public Double getSpend() {
            return spend;
        }

        public void setSpend(Double spend) {
            this.spend = spend;
        }

        public Byte getAccumulate() {
            return accumulate;
        }

        public void setAccumulate(Byte accumulate) {
            this.accumulate = accumulate;
        }
    }


    /**
     * 計算折扣金額
     *
     * @param discount
     * @param sourcePrice
     * @return
     */
    public static double calculationDiscount(Discount discount, double sourcePrice) {
        double discountPrice;
        if (discount.getType() == 0) {
            //金額折扣
            discountPrice = discount.getAmount();
        } else {
            //百分比折扣
            discountPrice = MoneyUtil.divide(MoneyUtil.multiply(sourcePrice, discount.getDiscount_value()), 100).doubleValue();
        }
        if (sourcePrice < discountPrice) {
            //折扣金額不能超出總額
            discountPrice = sourcePrice;
        }
//        else {
//            discountPrice = sourcePrice - discountPrice;
//        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountPrice));
    }

    public static double calculationMemberDiscount(int discountRate, double sourcePrice) {
        double discountPrice = MoneyUtil.divide(MoneyUtil.multiply(sourcePrice, discountRate), 100).doubleValue();
        if (sourcePrice < discountPrice) {
            //折扣金額不能超出總額
            discountPrice = sourcePrice;
        }
//        else {
//            discountPrice = sourcePrice - discountPrice;
//        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountPrice));
    }
}
