package com.gingersoft.gsa.cloud.base.order.commodity;


import com.gingersoft.gsa.cloud.base.order.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.order.bean.discount.OrderDiscount;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @author : bin
 * @create date: 2020-10-14
 * @update date: 2020-10-14
 * @description: 堂食食品
 */
@Getter
@Setter
@ToString
public class MealCommodity implements Commodity {

    private static final long serialVersionUID = -958791295551999853L;
    /**
     * 是否选择
     * 0 未选中
     * 1 被选中但不是主体
     * 2 作为主体被选中
     * 3 由三级菜单进入选中全部
     */
    private int selected = 0;
    //是否食品
    private boolean isIsfood = true;
    //父級下標
    private int parentIndex = 0;
    //自身下標
    private int myIndex = 0;
    //是否是新添加的食品（未送單）
    private boolean isNew = true;
    //是否顯示
    private boolean visible = true;
    //新点后是否自动展开
    private int autoMod = 0;
    //作用于套餐下子食品的限制数量
    private int limitQty = 0;
    //折扣比例
    private double PERCENTAGE = 0.00;
    //套餐编號
    private long comid;
    //細項編號
    private long mid;
    //修改数量前的数量
    private int changeBeforeQty = 0;
    //当前食品是否有子项
    private boolean hasChild = false;
    //背景色
    private int bgColor;
    //字體色
    private int fontColor;
    //是否组合商品 1-组合商品 2-组合商品的子商品
    private int ComboLevel = 0;
    //套餐食品是否自動跟餐
    private boolean isComboAuto = false;
    /**
     * 動態的最大選中數
     */
    private String currentMaxNumber = "";
    /**
     * 删除食品相关
     */
    //该食品是否修改过
    private boolean isModify = false;
    //修改食品前的数量
    private int modifyBeforeNumber = 0;
    //取消食品备注
    private String cancelReason;
    //取消食品原因ID
    private int reasonId;
    //取消食品数量
    private int cancelNumber;
    //"food" or "discount" or "modifiy"
    private int prop = FOOD_PROP;
    /**
     * 訂單Item類型
     * 1:主食品
     * 2:套餐
     * 3:細項
     * 4:折扣
     */
    public static final byte FOOD_PROP = 1;
    public static final byte COMBO_PROP = 2;
    public static final byte MODIFIER_PROP = 3;
    public static final byte DISCOUNT_PROP = 4;
    /***
     * 層級
     * 1:主食品
     * 2:子項or細項
     * 3:細項
     */
    private int itemType;
    /**
     * ID
     */
    private long id;
    /**
     * 父级ID
     */
    private long parentId;
    /**
     * 订单ID
     */
    private long orderId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品id
     */
    private long productId;
    /**
     * 父级商品ID
     */
    private long parentProductId;
    /**
     * 商品組id
     */
    private long topId;
    /**
     * 總價格(已經x數量)
     */
    private double price = 0;
    /**
     * 單價
     */
    private double unit_price = 0;
    /**
     * 餐盒費
     */
    private double lunchboxPrice;
    /**
     * 細項價格
     */
    private double itemsPrice;
    /**
     * 數量
     */
    private int number;
    /**
     * 已經使用優惠卷卷號列表逗號分割
     */
    private String userCouponNo;
    /**
     * 类型#1:优惠卷;2:商品;3:菜品;4:细项;5:折扣;
     */
    private byte type;
    /**
     *
     */
    private String qmUseData;
    /**
     * 备注
     */
    private String remark;
    /**
     * 细项(食品种类#食品id#详细分类ID#详细ID#名称#单价#位置索引#数量#细项总价格#posFid)
     */
    private String items;
    /**
     * 創建時間
     */
    private Date createTime = new Date();
    /**
     * 打印設定, 用逗號分隔, *=切紙
     */
    private String printSeting;
    /**
     * 是否参与折扣#0:不參與;1:參與;
     */
    private long ablediscount = 1;
    /**
     * 折扣實體
     */
    private Discount discount;
    /**
     * 折扣狀態#0:沒有折扣;1:折扣未送單;2:折扣已送單;
     */
    private int discountStatus;
    /**
     * 是否参与折扣#0:不參與;1:參與;
     **/
    private byte scAble = 1;
    /**
     * 額外食品加分
     */
    private double pointsAdd;
    /**
     * 換購食品所需積分
     */
    private double pointsRedeem;

    /**
     * 食品組
     */
    private String ftName;
    /**
     * 自定義組
     */
    private String majorName;
    /**
     * 状态#0:正常;1:删除;
     */
    private Byte status = STATUS_NORMAL;

    /**
     * 状态#0:正常;1:删除;
     */
    public static final byte STATUS_NORMAL = 0;
    public static final byte STATUS_DELETE = 1;


    /**
     * type編號#3:菜品;4:細項;5:折扣
     */
    public static final byte FOOD_TYPE = 3;
    public static final byte MODIFIER_TYPE = 4;
    public static final byte DISCOUNT_TYPE = 5;
    /**
     * 廚房單打印主項
     */
    private long ktPrintMainItem;

    /**
     * 0=系統顏色, 1=黑色, 2=紅色
     */
    private long printFont;
    /**
     * 當金額=0時, 是否打印在帳單上
     */
    private long printToBill;
    /**
     * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
     */
    private long printTo;
    /**
     * 是否打印价格
     */
    private long ktShowPrice;



    /**
     * 此食品是否包含折扣
     *
     * @param mealCommodityList
     * @param start_position
     * @param end_position
     * @return
     */
    public static boolean hasFoodDiscount(List<MealCommodity> mealCommodityList, int start_position, int end_position) {
        boolean hasDiscount = false;
        if (start_position == 0 && end_position == 0) {
            return hasDiscount;
        }
        for (int i = mealCommodityList.size() - 1; i >= 0; i--) {
            if (start_position <= i && i <= end_position) {
                MealCommodity mealCommodity = mealCommodityList.get(i);
                //添加折扣實體
                if (mealCommodity.getType() == MealCommodity.DISCOUNT_TYPE) {
                    hasDiscount = true;
                    break;
                }
            }
        }
        return hasDiscount;
    }

    /**
     * 已送單食品轉換
     *
     * @param orderList
     * @return
     */
    public static List<Commodity> orderTransMealCommoditys(List<OrderBean.OrderDetailsBean> orderList) {
        List<Commodity> mealCommodityList = new ArrayList<>();
        MealCommodity parentMealCommodity = null;
        long parentId = 0;
        //每個套餐食品折扣總額
        double discountSourcePrice = 0;
        //已到結尾或者下一個食品是主食品
        for (int i = 0; i < orderList.size(); i++) {
            OrderBean.OrderDetailsBean mealCommoditysBean = orderList.get(i);

            MealCommodity mealCommodity = new MealCommodity();
            mealCommodity.setOrderId(mealCommoditysBean.getOrderId());
            mealCommodity.setId(mealCommoditysBean.getId());
            mealCommodity.setProductId(mealCommoditysBean.getProductId());
            mealCommodity.setParentId(mealCommoditysBean.getParentId());
            mealCommodity.setTopId(mealCommoditysBean.getTopId());
            mealCommodity.setProductName(mealCommoditysBean.getProductName());
            mealCommodity.setNumber(mealCommoditysBean.getNumber());
            mealCommodity.setUnit_price(mealCommoditysBean.getPrice());
            mealCommodity.setPrice(mealCommoditysBean.getPrice() * mealCommoditysBean.getNumber());
            mealCommodity.setVisible(mealCommoditysBean.getStatus() == 0);
            mealCommodity.setPrintSeting(mealCommoditysBean.getPrintSetIng());
//            mealCommodity.setAutomod(foods.getAutomod());
            mealCommodity.setKtPrintMainItem(mealCommoditysBean.getKtPrintMainItem());
            mealCommodity.setPrintFont(mealCommoditysBean.getPrintFont());
            mealCommodity.setPrintToBill(mealCommoditysBean.getPrintToBill());
            mealCommodity.setPrintTo(mealCommoditysBean.getPrintTo());
            mealCommodity.setKtShowPrice(mealCommoditysBean.getKtShowPrice());
            mealCommodity.setAblediscount(mealCommoditysBean.getAblediscount());
            mealCommodity.setIsfood(mealCommoditysBean.getType() == FOOD_TYPE);
            mealCommodity.setNew(false);
            mealCommodity.setType(mealCommoditysBean.getType());
            mealCommodity.setItemType(getItemType(mealCommoditysBean, parentMealCommodity));
            mealCommodity.setAblediscount(mealCommoditysBean.getAblediscount());
            mealCommodity.setScAble(mealCommoditysBean.getScAble());
            mealCommodity.setPointsAdd(mealCommoditysBean.getPointsAdd());
            mealCommodity.setPointsRedeem(mealCommoditysBean.getPointsRedeem());
            mealCommodityList.add(mealCommodity);

//            if (mealCommodity.isIsfood()) {
//                parentMealCommodity = null;
//            }

            if (mealCommodity.getItemType() == 1) {
                parentId = mealCommodity.getId();
                discountSourcePrice = 0;
            }

            if (mealCommoditysBean.getRestaurantDiscountVO() != null) {
                //累加折扣總額
                discountSourcePrice = MoneyUtil.sum(discountSourcePrice, mealCommodity.getPrice());
                //食品折扣狀態為已送單
                mealCommodity.setDiscountStatus(2);
                //往下找
                int nextIndex = i + 1;
                if (orderList.size() == nextIndex || orderList.get(nextIndex).getParentId() == 0) {
                    //已到結尾或者下一個食品是主食品
                    Discount discount = getDiscountItem(mealCommoditysBean.getRestaurantDiscountVO());
                    if (discount != null) {
                        mealCommodityList.add(discountTransMealCommodity(discount, false, parentId, discountSourcePrice));
                    }
                }
            } else {
                mealCommodity.setDiscountStatus(0);
            }

            if (mealCommodity.isIsfood()) {
                parentMealCommodity = mealCommodity;
            }
        }
        return mealCommodityList;
    }

    //PLU可输入子项
    //食品数量支持小数 例如1.25
    private static Discount getDiscountItem(OrderBean.OrderDetailsBean.RestaurantDiscountVO discountBean) {
        Discount discount = new Discount();
        discount.setId(discountBean.getId());
        discount.setDiscount_value(discountBean.getDiscountValue());
        discount.setAmount(discountBean.getDiscountAmount());
        discount.setType(discountBean.getType());
        discount.setRemark(discountBean.getRemark());
        return discount;
    }

    public static int getItemType(OrderBean.OrderDetailsBean mealCommoditysBean, MealCommodity parentMealCommodity) {
        if (mealCommoditysBean != null) {
            if (mealCommoditysBean.getParentId() == 0) {
                return 1;
            }
            if (mealCommoditysBean.getParentId() != 0 && mealCommoditysBean.getType() == FOOD_TYPE) {
                return 2;
            }
            if (mealCommoditysBean.getParentId() != 0 && mealCommoditysBean.getType() == DISCOUNT_TYPE) {
                return 2;
            }
            if (parentMealCommodity != null && mealCommoditysBean.getParentId() != 0) {
                if (parentMealCommodity.getId() == mealCommoditysBean.getParentId()) {
                    //是父級
                    if (parentMealCommodity.getParentId() == 0 && mealCommoditysBean.getType() == FOOD_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentMealCommodity.getParentId() == 0 && mealCommoditysBean.getType() == DISCOUNT_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentMealCommodity.getParentId() != 0 && mealCommoditysBean.getType() == MODIFIER_TYPE) {
                        //第三層細項
                        return 3;
                    }
                }
                return 3;
            }
        }
        return 1;
    }

    /**
     * 折扣轉換
     *
     * @param discount
     * @return
     */
    public static MealCommodity discountTransMealCommodity(Discount discount, boolean isNew, long id, double sourcePrice) {

        double discountPrice = OrderDiscount.calculationDiscount(discount, sourcePrice);

        MealCommodity mealCommodity = new MealCommodity();
        mealCommodity.setProductName(discount.getRemark());
        mealCommodity.setId(discount.getId());
        mealCommodity.setTopId(id);
        mealCommodity.setParentId(id);
        mealCommodity.setProductId(discount.getId());
        mealCommodity.setNumber(1);
        mealCommodity.setPrice(discountPrice);
        mealCommodity.setUnit_price(discountPrice);
        mealCommodity.setOrderId(MyOrderManage.getInstance().getOrderId());
        mealCommodity.setIsfood(false);
        mealCommodity.setNew(isNew);
        mealCommodity.setType(DISCOUNT_TYPE);
        mealCommodity.setProp(DISCOUNT_PROP);
        mealCommodity.setSelected(2);
        mealCommodity.setItemType(2);

        mealCommodity.setDiscount(discount);

        return mealCommodity;
    }
}
