package com.gingersoft.gsa.cloud.base.order.order;


import com.gingersoft.gsa.cloud.base.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.constans.FoodSummaryConstans;

import lombok.Getter;
import lombok.Setter;

/**
 * @作者: bin
 * @創建時間: 2020-10-14
 * @更新時間: 2020-10-14
 * @描述:
 */
@Getter
@Setter
public abstract class BaseOrder {


    public BaseOrder() {
        shoppingCart = ShoppingCart.getInstance();
    }

    /**
     * 訂單類型
     *
     * @see FoodSummaryConstans#MEAL_MENU
     * @see FoodSummaryConstans#TAKEAWAY_TYPE
     */
    public volatile static int orderType = FoodSummaryConstans.RESTAURANT_MODE;
    /**
     * 訂單ID
     */
    protected long id = -1;
    /**
     * 訂單編號
     */
    protected String orderNo;
    /**
     * 購物車數據
     */
    protected ShoppingCart shoppingCart;


    protected void initialization() {
        orderType = FoodSummaryConstans.RESTAURANT_MODE;
        id = -1;
        orderNo = null;
        shoppingCart.initialization();
    }
}
