package com.gingersoft.gsa.cloud.user.login.mvp.presenter;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.gingersoft.gsa.cloud.user.login.R;
import com.gingersoft.gsa.cloud.user.login.mvp.contract.BaseLoginContract;
import com.gingersoft.gsa.cloud.user.login.mvp.ui.activity.LoginActivity;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.PermissionUtil;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;

@ActivityScope
public class BaseLoginPresenter<M extends BaseLoginContract.Model, V extends BaseLoginContract.View> extends BasePresenter<BaseLoginContract.Model, BaseLoginContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;


    private Activity IAcitivity;

    @Inject
    public BaseLoginPresenter(BaseLoginContract.Model model, BaseLoginContract.View rootView) {
        super(model, rootView);
        IAcitivity = (Activity) rootView;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void login(String account, String pwd) {
        if (account.equals("88888888") && pwd.equals("cc81081168")) {
            mRootView.startToSwitchServer();
            return;
        }
        RequestBody requestBody;
        requestBody = new FormBody.Builder()
                .add("userName", account.trim() + "")
                .add("passWord", pwd.trim() + "")
                .build();
        mModel.login(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading("登錄中..."))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<LoginBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull LoginBean info) {
                        if (info.isSuccess()) {
                            GsaCloudApplication.isLogin = true;
                            GsaCloudApplication.userName = info.getData().getUser().getUserName();
                            mRootView.showMessage("登陸成功");
                            mRootView.loginSuccess(info);
                        } else {
                            GsaCloudApplication.isLogin = false;
                            mRootView.showMessage(info.getErrMsg());
                            if (IAcitivity instanceof LoginActivity) {

                            } else {
                                mRootView.launchActivity(new Intent(IAcitivity, LoginActivity.class));
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        if (IAcitivity instanceof LoginActivity) {
                        } else {
                            mRootView.launchActivity(new Intent(IAcitivity, LoginActivity.class));
                        }
                    }
                });
    }
}
