package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;

import java.util.List;

/**
 * Created by Wyh on 2020/2/24.
 */
public class PaymentMethodColorAdapter extends BaseQuickAdapter<PaymentMethodBean.DataBean, BaseViewHolder> {


    private Context context;
    public PaymentMethodColorAdapter(Context context, @Nullable List<PaymentMethodBean.DataBean> data) {
        super(R.layout.item_payment_color, data);
        this.context = context;
    }

    @Override
    protected void convert(BaseViewHolder helper, PaymentMethodBean.DataBean item) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(GradientDrawable.OVAL);
        drawable.setColor(context.getResources().getColor(PaymentMethodAdapter.colors[helper.getAdapterPosition() % PaymentMethodAdapter.colors.length]));
        helper.getView(R.id.circle_color).setBackground(drawable);
        helper.setText(R.id.tv_payment_method, item.getPayName());
    }
}
