package com.gingersoft.supply_chain.mvp.bean;

import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/9
 * Time: 11:47
 * Use:購物車操作類，避免在列表中計算
 */
@Data
public class ShoppingCartBean {
    /**
     * 該供應商下的食品列表
     */
    List<PurchaseFoodBean> foodList;
    /**
     * 供應商id
     */
    private int supplierId;
    /**
     * 供應商名字
     */
    private String supplierName;
    /**
     * 最低採購金額
     */
    private double minimumAmount;
    /**
     * 供應商地址
     */
    private String address;
    /**
     * 選中的食材種類數量
     */
    private int selectSpeciesNum;
    /**
     * 選中的食材總價
     */
    private double selectFoodAmount;
    /**
     * 當前供應商下的食品是否全選
     */
    private boolean isAllSelect;
    /**
     *  是否閃爍：如果採購金額低於最低採購金額限制，會滾動到指定位置並閃爍
     */
    private boolean isFlashing = false;
}
