package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.di.component.DaggerWareHousingDetailsComponent;
import com.gingersoft.supply_chain.mvp.contract.WareHousingDetailsContract;
import com.gingersoft.supply_chain.mvp.presenter.WareHousingDetailsPresenter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;


/**
 * ================================================
 * Description: 入庫庫存詳情
 */
public class WareHousingDetailsFragment extends BaseSupplyChainFragment<WareHousingDetailsPresenter> implements WareHousingDetailsContract.View {

    public static WareHousingDetailsFragment newInstance() {
        WareHousingDetailsFragment fragment = new WareHousingDetailsFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWareHousingDetailsComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_ware_housing_details, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }
}
