package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.text.InputFilter;
import android.view.View;
import android.widget.EditText;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.utils.inputFilter.InputFilterUtils;
import com.gingersoft.supply_chain.R;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.impl.InputConfirmPopupView;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/15
 * Time: 9:45
 * Use: 新增分類的彈窗
 */
public class CategoryPopup extends ConfirmPopupView {
    private boolean showDelete;
    private EditText et_input;

    public CategoryPopup(@NonNull Context context, CharSequence title, CharSequence content, CharSequence hint, boolean showDelete) {
        super(context, R.layout.dialog_new_category);
        setTitleContent(title, content, hint);
        this.showDelete = showDelete;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        findViewById(R.id.iv_create_category_close).setOnClickListener(v -> dialog.dismiss());
        findViewById(R.id.tv_cancel).setVisibility(showDelete ? View.VISIBLE : GONE);
        et_input = findViewById(R.id.et_input);
        et_input.setFilters(new InputFilter[]{InputFilterUtils.getLengthFilter(getContext(), 4), InputFilterUtils.getChAndEnAndNumInputFilter(getContext())});
    }

    public EditText getEditText() {
        return et_input;
    }
}
