package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiInputBean;
import com.google.android.material.textfield.TextInputEditText;
import com.qmuiteam.qmui.util.QMUIKeyboardHelper;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use:
 */
public class InputProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_TYPE_INPUT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_input;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        MultiInputBean infoMultiBean = (MultiInputBean) t;
        //是否顯示必選
        baseViewHolder.setGone(R.id.multi_required, !infoMultiBean.isRequired());
        //設置標題
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
            baseViewHolder.setText(R.id.tv_multi_title, infoMultiBean.getShowTitle());
        } else {
            baseViewHolder.setText(R.id.tv_multi_title, "");
        }
        TextInputEditText editText = baseViewHolder.getView(R.id.ed_multi_value);
        setFilters(editText, infoMultiBean);
        initEditText(editText, infoMultiBean.getShowValue(), infoMultiBean.getHintText());

        TextWatcher textWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                infoMultiBean.setShowValue(editText.getText() + "");
                if (s == null || TextUtil.isEmptyOrNullOrUndefined(s.toString())) {
                    editText.setHint(infoMultiBean.getHintText());
                    baseViewHolder.setGone(R.id.iv_clear_multi_content, true);
                } else {
                    baseViewHolder.setGone(R.id.iv_clear_multi_content, false);
                }
            }
        };

        editText.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                editText.addTextChangedListener(textWatcher);
                RxJavaUtils.delay(1, aLong -> baseViewHolder.setGone(R.id.iv_clear_multi_content, TextUtil.isEmptyOrNullOrUndefined(editText)));
            } else {
                editText.removeTextChangedListener(textWatcher);
                RxJavaUtils.delay(1, aLong -> baseViewHolder.setGone(R.id.iv_clear_multi_content, true));
            }
        });
        ImageView ivClear = baseViewHolder.getView(R.id.iv_clear_multi_content);
        ivClear.setOnClickListener(v -> {
            editText.setText("");
            editText.requestFocus();
            QMUIKeyboardHelper.showKeyboard(editText, false);
            ivClear.setVisibility(View.GONE);
        });

        editText.setFocusable(infoMultiBean.isEdit());

//        if (infoMultiBean.isEdit()) {
//            editText.setTextColor(ContextCompat.getColor(context, R.color.color_3c));
//        } else {
//            editText.setTextColor(ContextCompat.getColor(context, R.color.color_c9));
//        }
    }


    private void initEditText(EditText tvThird, String showValue, String hintText) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(showValue)) {
            tvThird.setText(showValue);
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(hintText)) {
            tvThird.setHint(hintText);
        } else {
            tvThird.setText("");
        }
    }

    private void setFilters(EditText editText, MultiInputBean multiSelectBean) {
        if (multiSelectBean.getInputFilters() != null) {
            editText.setFilters(multiSelectBean.getInputFilters());
        } else {
            editText.setFilters(editText.getFilters());
        }

        if (multiSelectBean.getInputType() != -1) {
            editText.setInputType(multiSelectBean.getInputType());
        } else {
            editText.setInputType(editText.getInputType());
        }
    }

}
