package com.gingersoft.gsa.cloud.ui.adapter;

import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/17.
 */
public class BillMoneyAdapter extends BaseQuickAdapter<PayMethod, BaseViewHolder> {

    private String cashStr = "$";
    private int select_position = -1;

    public BillMoneyAdapter(@Nullable List<PayMethod> data) {
        super(R.layout.item_bill_money, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PayMethod datasBean) {
        LinearLayout ll_container = helper.getView(R.id.ll_container);
        ImageView iv_bill_delete = helper.getView(R.id.iv_bill_delete);
        TextView tv_bill_method_name = helper.getView(R.id.tv_bill_method_name);
        TextView tv_bill_money = helper.getView(R.id.tv_bill_money);

        tv_bill_method_name.setText(datasBean.getPayName());

        if (datasBean.getPayMoney() < 0) {
            tv_bill_money.setText("-" + cashStr + Math.abs(datasBean.getPayMoney()));
        } else {
            tv_bill_money.setText(cashStr + datasBean.getPayMoney());
        }

        tv_bill_method_name.setTextSize(datasBean.getPayMoneySize());
        tv_bill_money.setTextSize(datasBean.getPayMoneySize());

        tv_bill_method_name.setTextColor(datasBean.getPayMoneyTextColor());
        tv_bill_money.setTextColor(datasBean.getPayMoneyTextColor());

        if (select_position == helper.getAdapterPosition()) {
            ll_container.setBackgroundResource(R.color.itemSelected);
        } else {
            ll_container.setBackgroundResource(R.color.theme_background_color);
        }

        setOnItemClickListener((adapter, view, position) -> {
            if (mOnItemClickListener != null) {
                mOnItemClickListener.onItemClick(datasBean, position);
            }
        });
        iv_bill_delete.setOnClickListener((v -> {
            if (mOnItemClickListener != null)
                mOnItemClickListener.onItemDeleteClick(datasBean, helper.getPosition());
        }));
    }

    public int getSelect_position() {
        return select_position;
    }

    public void setSelect_position(int select_position) {
        this.select_position = select_position;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(PayMethod datasBean, int position);

        void onItemDeleteClick(PayMethod datasBean, int position);
    }

}
