package com.gingersoft.gsa.cloud.download.mvp.model.downmanager;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.threadPool.ThreadPoolManager;
import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.base.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.base.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.download.mvp.presenter.DownloadPresenter;
import com.jess.arms.utils.ArmsUtils;

import java.net.URLEncoder;
import java.util.List;

import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-25
 * 修订历史：2020-02-25
 * 描述：數據下載管理類
 */
public class DownloadManager {


    private static DownloadManager downloadManager;
    private Context context;
    //当前请求响应成功数
    private int responseSuccessCount;
    //当前请求响应失敗数
    private int responseErrorCount;
    //当前所需請求數
    private int requestCount;

    public static DownloadManager getInstance() {
        if (downloadManager == null) {
            downloadManager = new DownloadManager();
        }
        return downloadManager;
    }

    public DownloadManager takeRequestExecute(Context context, List<DownloadRequest> requests, DownloadPresenter presenter) {
        this.context = context;
        this.requestCount = requests.size();
        //重置响应数
        this.responseSuccessCount = 0;

        ThreadPoolManager poolManager = ThreadPoolManager.getInstence();

        for (int i = 0; i < requests.size(); i++) {
            DownloadRequest request = requests.get(i);
            if (request != null) {
                DownloadTaskImp taskImp = new DownloadTaskImp(request,presenter);
                poolManager.putExecutableTasks(taskImp);
            }
        }
        return this;
    }


    public void download(DownloadRequest request) {
        OkHttp3Utils.get(request.getUrl())
                .subscribeOn(Schedulers.io())
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<String>() {

                    @Override
                    public void onSubscribe(Disposable d) {
                    }

                    @Override
                    public void onNext(String data) {
                        if (listener != null) {
                            listener.onSuccess(data, request.getDownTag());
                        }
                        //同步响应数加+1
                        responseSuccessCount++;
                    }

                    @Override
                    public void onError(Throwable t) {
                        if (listener != null) {
                            listener.onError(t, request.getDownTag());
                        }
                        responseErrorCount++;
                    }

                    @Override
                    public void onComplete() {
                        if (responseSuccessCount == requestCount) {
                            if (listener != null) {
                                listener.noComplete();
                            }
                        }
                    }
                });
    }


    private OnDownloadResultListener listener;

    public void setDownloadResultListener(OnDownloadResultListener listener) {
        this.listener = listener;
    }

    public interface OnDownloadResultListener {

        void onSuccess(String respose, int downTag);

        void onError(Throwable t, int downTag);

        void noComplete();
    }
}
