package com.gingersoft.gsa.other_order_mode.data.model.bean;

import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/7/10
 * 修订历史：2018/7/10
 * 描述：
 */

public class PayTypeInfo {


    /**
     * code : 1
     * data : {"id":15558,"amount":0.05,"remain":161457,"status":0,"orderType":2,"payType":[{"id":6,"payName":"支付宝HK","isdefault":1,"remarks":null},{"id":11,"payName":"服务员确认","isdefault":0,"remarks":null},{"id":5,"payName":"TNG","isdefault":0,"remarks":null},{"id":8,"payName":"支付宝","isdefault":0,"remarks":null},{"id":9,"payName":"微信","isdefault":0,"remarks":null}],"restaurantId":26,"restaurantName":"Gingersoft"}
     * errorMsg : 成功
     * page : null
     */

    private String code;
    private DataBean data;
    private String errorMsg;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public DataBean getData() {
        return data;
    }

    public void setData(DataBean data) {
        this.data = data;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public static class DataBean {
        /**
         * id : 15558
         * amount : 0.05
         * remain : 161457
         * status : 0
         * orderType : 2
         * payType : [{"id":6,"payName":"支付宝HK","isdefault":1,"remarks":null},{"id":11,"payName":"服务员确认","isdefault":0,"remarks":null},{"id":5,"payName":"TNG","isdefault":0,"remarks":null},{"id":8,"payName":"支付宝","isdefault":0,"remarks":null},{"id":9,"payName":"微信","isdefault":0,"remarks":null}]
         * restaurantId : 26
         * restaurantName : Gingersoft
         */

        private int id;
        private double amount;
        private int remain;
        private String appleToken;
        private int status;
        private int orderType;
        private int restaurantId;
        private String restaurantName;
        private List<PayTypeBean> payType;

        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public double getAmount() {
            return amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public int getRemain() {
            return remain;
        }

        public void setRemain(int remain) {
            this.remain = remain;
        }

        public int getStatus() {
            return status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getOrderType() {
            return orderType;
        }

        public void setOrderType(int orderType) {
            this.orderType = orderType;
        }

        public int getRestaurantId() {
            return restaurantId;
        }

        public void setRestaurantId(int restaurantId) {
            this.restaurantId = restaurantId;
        }

        public String getRestaurantName() {
            return restaurantName;
        }

        public void setRestaurantName(String restaurantName) {
            this.restaurantName = restaurantName;
        }

        public List<PayTypeBean> getPayType() {
            return payType;
        }

        public void setPayType(List<PayTypeBean> payType) {
            this.payType = payType;
        }

        public String getAppleToken() {
            return appleToken;
        }

        public void setAppleToken(String appleToken) {
            this.appleToken = appleToken;
        }

        public static class PayTypeBean {
            /**
             * id : 6
             * payName : 支付宝HK
             * isdefault : 1
             * remarks : null
             */

            private int id;
            private long isdefault;
            private String payName;
            private String remarks;
            private String payName3;
            private String payName2;
            private boolean checked;

            public int getId() {
                return id;
            }

            public void setId(int id) {
                this.id = id;
            }

            public long getIsdefault() {
                return isdefault;
            }

            public void setIsdefault(long isdefault) {
                this.isdefault = isdefault;
            }

            public String getPayName() {
                return payName;
            }

            public void setPayName(String payName) {
                this.payName = payName;
            }

            public String getRemarks() {
                return remarks;
            }

            public void setRemarks(String remarks) {
                this.remarks = remarks;
            }

            public boolean isChecked() {
                return checked;
            }

            public void setChecked(boolean checked) {
                this.checked = checked;
            }

            public String getPayName3() {
                return payName3;
            }

            public void setPayName3(String payName3) {
                this.payName3 = payName3;
            }

            public String getPayName2() {
                return payName2;
            }

            public void setPayName2(String payName2) {
                this.payName2 = payName2;
            }
        }
    }


    public static List<PayMethod> getPayMethodByPayType(PayTypeInfo.DataBean payTypes) {
        List<PayMethod> payMethods = new ArrayList<>();
        if (payTypes == null) {
            return payMethods;
        }
        if (payTypes.payType == null) {
            return payMethods;
        }
        for (PayTypeInfo.DataBean.PayTypeBean payType : payTypes.payType) {
            PayMethod payMethod = new PayMethod(payType.id, payType.payName, "", payType.remarks, payType.payName, payType.payName2, payType.payName3, "");
            payMethods.add(payMethod);
        }
        return payMethods;
    }
}
