package com.gingersoft.gsa.other_order_mode.util

import com.gingersoft.gsa.other_order_mode.data.DeliveryRepository
import com.gingersoft.gsa.other_order_mode.data.HistoryOrderRepository
import com.gingersoft.gsa.other_order_mode.data.WeatherRepository
import com.gingersoft.gsa.other_order_mode.data.network.CoolWeatherNetwork
import com.gingersoft.gsa.other_order_mode.data.network.DeliveryNetwork
import com.gingersoft.gsa.other_order_mode.model.factory.DeliveryFactory
import com.gingersoft.gsa.other_order_mode.model.factory.HistoryOrderModelFactory
import com.gingersoft.gsa.other_order_mode.model.factory.WeatherModelFactory


object InjectorUtil {


    fun getWeatherModelFactory() = WeatherModelFactory(getWeatherRepository())

    private fun getWeatherRepository() = WeatherRepository.getInstance(CoolWeatherNetwork.getInstance())


    fun getHistoryModelFactory() = HistoryOrderModelFactory(getHistoryRepository())

    private fun getHistoryRepository() = HistoryOrderRepository.getInstance(CoolWeatherNetwork.getInstance())

    fun getDeliveryFactory() = DeliveryFactory(DeliveryRepository.getInstance(DeliveryNetwork.getInstance()))

}