package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;

import com.epson.epos2.Epos2Exception;
import com.epson.epos2.printer.Printer;
import com.epson.epos2.printer.ReceiveListener;

public class EpsonPrint {

    private Printer mPrinter = null;

    /**
     * 初始化
     *
     * @return
     */
    public boolean initializeObject(Context context, ReceiveListener receiveListener) {
        try {
            //第一個參數是機型，第二個參數是語言，
            mPrinter = new Printer(Printer.TM_U220, Printer.MODEL_TAIWAN, context);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        mPrinter.setReceiveEventListener(receiveListener);
        return true;
    }

    public void finalizeObject() {
        if (mPrinter == null) {
            return;
        }

        mPrinter.setReceiveEventListener(null);
        try {
            mPrinter.disconnect();
            isConnect = false;
        } catch (Epos2Exception e) {
            e.printStackTrace();
        }
        mPrinter = null;
    }

    public void disconnect() throws Epos2Exception {
        mPrinter.disconnect();
        isConnect = false;
    }

    public void clearCommandBuffer() {
        mPrinter.clearCommandBuffer();
    }

    /**
     * 創建打印數據
     *
     * @return
     */
    private boolean createPrintData(Bitmap bitmap) {
//        String method = "";
//        StringBuilder textData = new StringBuilder();
//        final int barcodeWidth = 2;
//        final int barcodeHeight = 100;
        if (mPrinter == null) {
            return false;
        }
        try {
//                method = "addPulse";
//                mPrinter.addPulse(Printer.PARAM_DEFAULT,
//                        Printer.PARAM_DEFAULT);
//            method = "addTextAlign";
//            mPrinter.addTextAlign(Printer.ALIGN_CENTER);
//            method = "addImage";
            mPrinter.addImage(bitmap, 0, 0,
                    bitmap.getWidth(),
                    bitmap.getHeight(),
                    Printer.COLOR_NONE,
                    Printer.MODE_MONO,
                    Printer.HALFTONE_DITHER,
                    Printer.PARAM_DEFAULT,
                    Printer.COMPRESS_AUTO);
            //COLOR_NONE 為普通顏色 COLOR_2為紅色
//            method = "addCut";
            mPrinter.addCut(Printer.CUT_FEED);
//            method = "addFeedLine";
//            mPrinter.addFeedLine(1);
//            textData.append("THE STORE 123 (555) 555 – 5555\n");
//            textData.append("STORE DIRECTOR – John Smith\n");
//            textData.append("\n");
//            textData.append("7/01/07 16:58 6153 05 0191 134\n");
//            textData.append("ST# 21 OP# 001 TE# 01 TR# 747\n");
//            textData.append("------------------------------\n");
//            method = "addText";
//            mPrinter.addText(textData.toString());
//            textData.delete(0, textData.length());
//
//            textData.append("400 OHEIDA 3PK SPRINGF  9.99 R\n");
//            textData.append("410 3 CUP BLK TEAPOT    9.99 R\n");
//            textData.append("445 EMERIL GRIDDLE/PAN 17.99 R\n");
//            textData.append("438 CANDYMAKER ASSORT   4.99 R\n");
//            textData.append("474 TRIPOD              8.99 R\n");
//            textData.append("433 BLK LOGO PRNTED ZO  7.99 R\n");
//            textData.append("458 AQUA MICROTERRY SC  6.99 R\n");
//            textData.append("493 30L BLK FF DRESS   16.99 R\n");
//            textData.append("407 LEVITATING DESKTOP  7.99 R\n");
//            textData.append("441 **Blue Overprint P  2.99 R\n");
//            textData.append("476 REPOSE 4PCPM CHOC   5.49 R\n");
//            textData.append("461 WESTGATE BLACK 25  59.99 R\n");
//            textData.append("------------------------------\n");
//            method = "addText";
//            mPrinter.addText(textData.toString());
//            textData.delete(0, textData.length());
//
//            textData.append("SUBTOTAL                160.38\n");
//            textData.append("TAX                      14.43\n");
//            method = "addText";
//            mPrinter.addText(textData.toString());
//            textData.delete(0, textData.length());
//
//            method = "addTextSize";
//            mPrinter.addTextSize(2, 2);
//            method = "addText";
//            mPrinter.addText("TOTAL    174.81\n");
//            method = "addTextSize";
//            mPrinter.addTextSize(1, 1);
//            method = "addFeedLine";
//            mPrinter.addFeedLine(1);
//
//            textData.append("CASH                    200.00\n");
//            textData.append("CHANGE                   25.19\n");
//            textData.append("------------------------------\n");
//            method = "addText";
//            mPrinter.addText(textData.toString());
//            textData.delete(0, textData.length());
//
//            textData.append("Purchased item total number\n");
//            textData.append("Sign Up and Save !\n");
//            textData.append("With Preferred Saving Card\n");
//            method = "addText";
//            mPrinter.addText(textData.toString());
//            textData.delete(0, textData.length());
//            method = "addFeedLine";
//            mPrinter.addFeedLine(2);
//
//            method = "addBarcode";
//            mPrinter.addBarcode("01209457",
//                                Printer.BARCODE_CODE39,
//                                Printer.HRI_BELOW,
//                                Printer.FONT_A,
//                                barcodeWidth,
//                                barcodeHeight);
        } catch (Exception e) {
            mPrinter.clearCommandBuffer();
            return false;
        }
//        textData = null;
        return true;
    }

    public boolean printData(String ip, Bitmap bitmap) {
        if (!createPrintData(bitmap)) {
            return false;
        }
        if (mPrinter == null) {
            return false;
        }
        if (!connectPrinter(ip)) {
            mPrinter.clearCommandBuffer();
            return false;
        }
        try {
            mPrinter.sendData(Printer.PARAM_DEFAULT);
        } catch (Exception e) {
            mPrinter.clearCommandBuffer();
//            ShowMsg.showException(e, "sendData", mContext);
            try {
                mPrinter.disconnect();
            } catch (Exception ex) {
                // Do nothing
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private boolean isConnect = false;

    private boolean connectPrinter(String ip) {
        if (mPrinter == null) {
            return false;
        }
        if (isConnect) {
            return true;
        }
        try {
//            mPrinter.getInterval()
            mPrinter.connect("TCP:" + ip, Printer.PARAM_DEFAULT);
            isConnect = true;
        } catch (Exception e) {
            isConnect = false;
//            ShowMsg.showException(e, "connect", mContext);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}
