/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import com.epson.epos2.printer.EfxExtractor;
import com.epson.epos2.printer.RcxHeaderAnalyzer;
import com.epson.epos2.printer.firmwareUpdateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FirmwareUpdate {
    FirmwareUpdate() {
    }

    public static int convertEpos2exToEpos2CallbackCode(int ex) {
        int code = 255;
        switch (ex) {
            case 1: {
                code = 39;
                break;
            }
            case 2: {
                code = 35;
                break;
            }
            case 3: {
                code = 1;
                break;
            }
            case 4: {
                code = 37;
                break;
            }
            case 5: {
                code = 30;
                break;
            }
            case 6: {
                code = 38;
                break;
            }
            case 7: {
                code = 2;
                break;
            }
            case 8: {
                code = 34;
                break;
            }
            case 10: {
                code = 36;
                break;
            }
            case 255: {
                code = 255;
                break;
            }
            default: {
                code = 255;
            }
        }
        return code;
    }

    public static RcxHeaderAnalyzer getRcxHeaderAnalyzer(byte[] rcxImage) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rcxImage);
        RcxHeaderAnalyzer rcxHeaderAnalyzer = new RcxHeaderAnalyzer(inputStream);
        if (!rcxHeaderAnalyzer.valid()) {
            rcxHeaderAnalyzer = null;
        }
        return rcxHeaderAnalyzer;
    }

    public static byte[] extract(String workingDirectory, String efuFilename) throws firmwareUpdateException {
        boolean extractResult = false;
        byte[] extractedFrimwareImage = null;
        String fwImageFile = workingDirectory + efuFilename;
        String zipFWImageFile = workingDirectory + "zwpfoityjuivuyegcuw";
        String cryptedRcxFWImageFile = workingDirectory + "cr19fm29fktnvysicl";
        String rcxFWImageFile = workingDirectory + "rcvuslvcneovuhbfgkcxp";
        try {
            System.gc();
            File file = new File(zipFWImageFile);
            file.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(zipFWImageFile);
            FileInputStream inputStream = new FileInputStream(fwImageFile);
            extractResult = EfxExtractor.efxToZip(inputStream, outputStream);
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
            if (!extractResult) {
                throw new firmwareUpdateException(43);
            }
            System.gc();
            file = new File(cryptedRcxFWImageFile);
            file.createNewFile();
            outputStream = new FileOutputStream(cryptedRcxFWImageFile);
            inputStream = new FileInputStream(zipFWImageFile);
            extractResult = EfxExtractor.zipToCtyptedRcx(inputStream, outputStream);
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
            if (!extractResult) {
                throw new firmwareUpdateException(43);
            }
            System.gc();
            inputStream = new FileInputStream(zipFWImageFile);
            String passwordSeed = EfxExtractor.getUnzippedFilename(inputStream);
            ((InputStream)inputStream).close();
            if (passwordSeed == "") {
                throw new firmwareUpdateException(43);
            }
            System.gc();
            ByteArrayOutputStream bAoutputStream = new ByteArrayOutputStream();
            inputStream = new FileInputStream(cryptedRcxFWImageFile);
            extractResult = EfxExtractor.cryptedRcxToRcx(inputStream, bAoutputStream, passwordSeed);
            ((InputStream)inputStream).close();
            if (!extractResult) {
                bAoutputStream.close();
                throw new firmwareUpdateException(43);
            }
            extractedFrimwareImage = bAoutputStream.toByteArray();
            bAoutputStream.close();
        }
        catch (IOException e) {
            throw new firmwareUpdateException(44);
        }
        catch (firmwareUpdateException e) {
            throw e;
        }
        finally {
            File file = new File(zipFWImageFile);
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(cryptedRcxFWImageFile)).exists()) {
                file.delete();
            }
            if ((file = new File(rcxFWImageFile)).exists()) {
                file.delete();
            }
        }
        return extractedFrimwareImage;
    }
}

