package com.gingersoft.coldchain_module.mvp.model;

import android.app.Application;

import com.gingersoft.coldchain_module.mvp.contract.OrderDetailsContract;
import com.gingersoft.coldchain_module.mvp.model.bean.CancelLogisticsBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ReadBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.coldchain_module.mvp.model.service.OrderDetailService;
import com.gingersoft.gsa.cloud.table.PublicBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@ActivityScope
public class OrderDetailsModel extends BaseModel implements OrderDetailsContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderDetailsModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<OrderDetails> findOrderDetails(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).findOrderDetails(requestBody);
    }

    @Override
    public Observable<ShipAnyOrdersNewBean> thirdDelivery(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).thirdDelivery(requestBody);
    }

    @Override
    public Observable<UpdateOrderStatusBean> updateOrderStatus(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).gsUpdateOrderStatus(requestBody);
    }

    @Override
    public Observable<CancelLogisticsBean> cancelLogistics(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).cancelLogistics(requestBody);
    }

    @Override
    public Observable<ReadBean> setIsRead(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).setIsRead(requestBody);
    }

    @Override
    public Observable<String> addPrj(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).addPrj(requestBody);
    }

    @Override
    public Observable<PublicBean> updatePrintPdfStatus(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).updatePrintPdfStatus(requestBody);
    }


}