package com.joe.print.mvp.contract;

import com.gingersoft.gsa.cloud.table.PublicBean;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface LocalPrintContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadView(List<PrintCurrencyBean> printCurrencyBeans);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<PublicBean> getPrinterCurrencyList(String restaurantId);
        Observable<PublicBean> deletePrinterCurrency(RequestBody requestBody);

    }
}
