package com.gingersoft.gsa.cloud.table;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/11
 * 修订历史：2018/8/11
 * 描述：保存餐廳UI配置信息
 */
@Data
public class RestaurantExpandInfo {

    @Data
    public static final class UIStyleConfiguration {
        /**
         * 食品組、食品、細項、折扣行列寬高
         */
        private int foodGroupRow = 2;
        private int foodGroupColumn = 6;
        private int foodColumn = 4;
        private int comboColumn = 4;
        private int modColumn = 4;
        private int discountColumn = 4;
        /**
         * 食品組、食品、細項、折扣Item高度
         */
        private int foodGroupBtnHeight = 150;
        private int foodBtnHeight = 120;
        private int modBtnHeight = 80;
        private int comboHeight = 90;
        private int discountHeight = 80;

        private int LayoutQtyHeight = 40;
        /**
         * 食品組、食品、細項、折扣字體大小
         */
        private int foodGroupFontSize = 14;
        private int foodFontSize = 14;
        private int comboFontSize = 12;
        private int modFontSize = 12;
        private int discountFontSize = 12;

        private int OrderNumberShowSize = 20;
        private int OrderNumberFontSize = 7;
        private int OrderNumberChildShowSize = 20;
        private int OrderNumberChildFontSize = 10;

        //估清控制食品字體大小
        private int soldoutCtrlFoodFontSize = 16;
    }


    @Data
    public static final class FunctionConfiguration {
        /**
         * 賬單小數相關
         */
        private int Rounding;
        private int RoundingDecimal;
        private int ItemDecimals;

        private int DeliveryPrintCount;//外送印單打印次數
        private int DeliveryClosingPC;//外送結賬打印次數
        private int TableModePrintCount;//餐檯印單打印次數
        private int TableModeClosingPC;//餐檯模式結賬單打印次數
        private int OrderReceivingTimeout;//外送接單超時時間
        private int PrintMemberInfo;//是否打印會員信息
        private int PrintPage;//是否打印頁數
        private int PrintMergerFood;//是否合併食品
        private int PrintStatisticsAmount;//是否顯示統計打印數
        private int PrintFirstOrder;//是否打印"頭單"文字
        private int FrozenChainAutoOrder;//是否自動接單 為0true
        private int MergeSendFood;//送單是否自動合併食品
        private int AutoPrinterPaper;//送單自動打印上菜紙
        private int ToPrintQRCode;//結賬是否打印積分二維碼
        private int AutoQuitTime = 600;//餐檯模式下單頁多少秒不操作返回餐檯頁面
    }

}
