package com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.table.PublicBean;
import com.gingersoft.gsa.cloud.login.mvp.server.LoginService;
import com.gingersoft.gsa.cloud.ui.bean.mode.BrandsBean;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;

import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.contract.ChooseRestaurantContract;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@ActivityScope
public class ChooseRestaurantModel extends BaseModel implements ChooseRestaurantContract.Model{
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public ChooseRestaurantModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BrandsBean> getRestaurantList() {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .getRestaurantList();
    }

    @Override
    public Observable<PublicBean> getLoginLimit(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .getLoginLimit(restaurantId);
    }

    @Override
    public Observable<Object> loginOut(int userId, RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .loginOut(userId, requestBody);
    }
}