package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.BusinessReportModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.BusinessReportContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.BusinessReportFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = BusinessReportModule.class, dependencies = AppComponent.class)
public interface BusinessReportComponent {
    void inject(BusinessReportFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        BusinessReportComponent.Builder view(BusinessReportContract.View view);

        BusinessReportComponent.Builder appComponent(AppComponent appComponent);

        BusinessReportComponent build();
    }
}