package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.main.mvp.model.bean.HomeTurnoverBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainOrderInfoChartBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/10.
 * 首頁和報表
 */
public interface MainReportService {
    //支付分析報表
    @POST("wx/findPayMode" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<PaymentMethodBean> getPaymentInfo(@Body RequestBody requestBody);
    //銷售分析報表
    @POST("wx/findFoodTop" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SalesFoodsBean> getSalesReportInfo(@Body RequestBody requestBody);
    //營業信息
    @POST("wx/doBusiness" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<HomeTurnoverBean> getRestaurantReport(@Body RequestBody requestBody);
    //
    @POST("wx/findOrderInfoChart" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MainOrderInfoChartBean> getOrderInfoChart(@Body RequestBody requestBody);
    //獲取首頁功能列表
    @GET("user/resource/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<String> getRestaurantFunList(@Query("restaurantId") String restaurantId);
}
