package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.PaymentMethodBean;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/2/24.
 */
public class PaymentMethodColorAdapter extends BaseQuickAdapter<PaymentMethodBean.DataBean, BaseViewHolder> {

    private int[] colors = new int[]{R.color.payment_method_color1,
            R.color.payment_method_color2, R.color.payment_method_color3,
            R.color.payment_method_color4, R.color.payment_method_color5,
            R.color.payment_method_color6, R.color.payment_method_color7,
            R.color.payment_method_color8};
    private Context context;
    public PaymentMethodColorAdapter(Context context, @Nullable List<PaymentMethodBean.DataBean> data) {
        super(R.layout.item_payment_color, data);
        this.context = context;
    }

    @Override
    protected void convert(BaseViewHolder helper, PaymentMethodBean.DataBean item) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(GradientDrawable.OVAL);
        drawable.setColor(context.getResources().getColor(colors[helper.getAdapterPosition() % colors.length]));
        helper.getView(R.id.circle_color).setBackground(drawable);
        helper.setText(R.id.tv_payment_method, item.getPayName());
    }
}
