package com.joe.print.mvp.ui.adapter;

import android.content.Context;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;

import java.util.List;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/16.
 */
public class PrinterListAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {
    private Context mContext;

    public PrinterListAdapter(@Nullable List<PrinterDeviceBean> data, Context mContext) {
        super(R.layout.printer_item, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        helper.setText(R.id.tv_printer_name, item.getIp() + "");
        helper.setText(R.id.tv_printer_ip, String.format(mContext.getString(R.string.print_ip), item.getIp()));
        helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), item.getPort() + ""));
//        helper.
    }

    public void notifyData(List<PrinterDeviceBean> data) {
        this.mData = data;
        super.notifyDataSetChanged();
    }
}
