package com.gingersoft.gsa.cloud.base.adapter.print;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;

import java.util.List;

/**
 * Created by Wyh on 2020/2/20.
 */
public class KitChenPrintFoodAdapter extends BaseQuickAdapter<OrderDetail, BaseViewHolder> {

    public KitChenPrintFoodAdapter(@Nullable List<OrderDetail> data) {
        super(R.layout.print_kitchen_item_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderDetail item) {
        if (item.getItemType() == 2) {
            //細項，縮進
            helper.setText(R.id.tv_food_number, "\u3000" + item.getNumber());
        } else if (item.getItemType() == 3) {
            //細項，縮進
            helper.setText(R.id.tv_food_number, "\u3000\u3000" + item.getNumber());
        } else {
            helper.setText(R.id.tv_food_number, item.getNumber() + "");
        }
        helper.setText(R.id.tv_food_name, item.getProductName());
    }
}
