package com.gingersoft.gsa.cloud.base.utils.request;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.encryption.MD5;
import com.gingersoft.gsa.cloud.base.utils.mobile.DeviceUuidFactory;
import com.gingersoft.gsa.cloud.base.utils.mobile.Installation;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

import static com.gingersoft.gsa.cloud.base.application.GsaCloudApplication.getLoginToken;

/**
 * autour: ELEGANT_BIN
 * date: 2018/4/9 18:56
 * update: 2018/4/9 18:56
 * description:
 */

public class RequestUtils {


    /**
     * @param dataMap
     * @param times
     * @return
     * @Title: getSign
     * @Description: TODO(获取签名)
     */
    public static String getSign(Context context, Map<String, Object> dataMap, long times) {
        String sign = "";
        String token = GsaCloudApplication.getLoginToken(context);
        if (!TextUtils.isEmpty(token)) {
            MD5 md5 = new MD5();
            Set<String> set = new TreeSet<>();
            Set<String> keys = dataMap.keySet();
            set.addAll(keys);
            StringBuffer buffer = new StringBuffer();
            for (String key : set) {
                buffer.append(key);
                buffer.append("=");
                buffer.append(dataMap.get(key) + "");
            }
            buffer.append("token=" + token + "");
            buffer.append("times=" + times + "");
            sign = md5.GetMD5Code(buffer.toString());
            Log.e("joe", "bufferStr=====> " + buffer.toString());
        }
        return sign;
    }


    private static String getuUid(Context context) {
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(context);
        UUID deviceUuid = deviceUuidFactory.getDeviceUuid();
        if (deviceUuid != null) {
            return deviceUuid.toString();
        } else {
            return Installation.id(context);
        }
    }


}
