package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "FID");
        public final static Property ParentId = new Property(1, Long.class, "parentId", false, "PARENT_ID");
        public final static Property RestaurantId = new Property(2, Long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property IsParent = new Property(3, Byte.class, "isParent", false, "IS_PARENT");
        public final static Property SeqNo = new Property(4, Long.class, "seqNo", false, "SEQ_NO");
        public final static Property FoodName = new Property(5, String.class, "foodName", false, "FOOD_NAME");
        public final static Property FoodName1 = new Property(6, String.class, "foodName1", false, "FOOD_NAME1");
        public final static Property FoodName2 = new Property(7, String.class, "foodName2", false, "FOOD_NAME2");
        public final static Property Plu = new Property(8, String.class, "plu", false, "PLU");
        public final static Property PosFid = new Property(9, String.class, "posFid", false, "POS_FID");
        public final static Property FoodDesc = new Property(10, String.class, "foodDesc", false, "FOOD_DESC");
        public final static Property LimitAmount = new Property(11, Long.class, "limitAmount", false, "LIMIT_AMOUNT");
        public final static Property LimitType = new Property(12, Long.class, "limitType", false, "LIMIT_TYPE");
        public final static Property FoodSummary = new Property(13, Long.class, "foodSummary", false, "FOOD_SUMMARY");
        public final static Property Invisible = new Property(14, Long.class, "invisible", false, "INVISIBLE");
        public final static Property AutoMod = new Property(15, Byte.class, "autoMod", false, "AUTO_MOD");
        public final static Property Price = new Property(16, Double.class, "price", false, "PRICE");
        public final static Property MarketPrice = new Property(17, Double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property LunchboxPrice = new Property(18, Double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImgUrlSmall = new Property(19, String.class, "imgUrlSmall", false, "IMG_URL_SMALL");
        public final static Property Imageurl = new Property(20, String.class, "imageurl", false, "IMAGEURL");
        public final static Property RiceponInvisible = new Property(21, Long.class, "riceponInvisible", false, "RICEPON_INVISIBLE");
        public final static Property Cost = new Property(22, Double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(23, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(24, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(25, Long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(26, Long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(27, Long.class, "isSold", false, "IS_SOLD");
        public final static Property CreateBy = new Property(28, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(29, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(30, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(31, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PeriodId = new Property(32, Long.class, "periodId", false, "PERIOD_ID");
        public final static Property AbleDiscount = new Property(33, Long.class, "ableDiscount", false, "ABLE_DISCOUNT");
        public final static Property Takeaway = new Property(34, Long.class, "takeaway", false, "TAKEAWAY");
        public final static Property BlueEdit = new Property(35, Long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property CartEdit = new Property(36, Long.class, "cartEdit", false, "CART_EDIT");
        public final static Property AutoMerge = new Property(37, Long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property PrintSeting = new Property(38, String.class, "printSeting", false, "PRINT_SETING");
        public final static Property IsPrintQueueCode = new Property(39, Long.class, "isPrintQueueCode", false, "IS_PRINT_QUEUE_CODE");
        public final static Property QueueHeadId = new Property(40, Long.class, "queueHeadId", false, "QUEUE_HEAD_ID");
        public final static Property Approve = new Property(41, Long.class, "approve", false, "APPROVE");
        public final static Property PrintFont = new Property(42, Long.class, "printFont", false, "PRINT_FONT");
        public final static Property AdvPrice = new Property(43, Long.class, "advPrice", false, "ADV_PRICE");
        public final static Property PrintToBill = new Property(44, Long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property PointsAdd = new Property(45, Double.class, "pointsAdd", false, "POINTS_ADD");
        public final static Property PointsRatio = new Property(46, Long.class, "pointsRatio", false, "POINTS_RATIO");
        public final static Property PointsRedeem = new Property(47, Double.class, "pointsRedeem", false, "POINTS_REDEEM");
        public final static Property KtPrintMainItem = new Property(48, Long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(49, Long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property PrintTo = new Property(50, Long.class, "printTo", false, "PRINT_TO");
        public final static Property ToPax = new Property(51, Long.class, "toPax", false, "TO_PAX");
        public final static Property FoodType = new Property(52, Long.class, "foodType", false, "FOOD_TYPE");
        public final static Property MajorMainId = new Property(53, Long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(54, Long.class, "deptId", false, "DEPT_ID");
        public final static Property ServiceCharge = new Property(55, Byte.class, "serviceCharge", false, "SERVICE_CHARGE");
        public final static Property ColorId = new Property(56, Long.class, "colorId", false, "COLOR_ID");
        public final static Property Conditions = new Property(57, Long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(58, Long.class, "isRt", false, "IS_RT");
        public final static Property Deletes = new Property(59, Long.class, "deletes", false, "DELETES");
        public final static Property IsTimingFood = new Property(60, Long.class, "isTimingFood", false, "IS_TIMING_FOOD");
        public final static Property MinLongTime = new Property(61, Long.class, "minLongTime", false, "MIN_LONG_TIME");
        public final static Property UnitTime = new Property(62, Long.class, "unitTime", false, "UNIT_TIME");
        public final static Property UnitPrice = new Property(63, Double.class, "unitPrice", false, "UNIT_PRICE");
        public final static Property FreeLongTime = new Property(64, Long.class, "freeLongTime", false, "FREE_LONG_TIME");
        public final static Property FreePeriodBegin = new Property(65, java.util.Date.class, "freePeriodBegin", false, "FREE_PERIOD_BEGIN");
        public final static Property IsStatistic = new Property(66, Long.class, "isStatistic", false, "IS_STATISTIC");
    }


    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"FID\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"PARENT_ID\" INTEGER," + // 1: parentId
                "\"RESTAURANT_ID\" INTEGER," + // 2: restaurantId
                "\"IS_PARENT\" INTEGER," + // 3: isParent
                "\"SEQ_NO\" INTEGER," + // 4: seqNo
                "\"FOOD_NAME\" TEXT," + // 5: foodName
                "\"FOOD_NAME1\" TEXT," + // 6: foodName1
                "\"FOOD_NAME2\" TEXT," + // 7: foodName2
                "\"PLU\" TEXT," + // 8: plu
                "\"POS_FID\" TEXT," + // 9: posFid
                "\"FOOD_DESC\" TEXT," + // 10: foodDesc
                "\"LIMIT_AMOUNT\" INTEGER," + // 11: limitAmount
                "\"LIMIT_TYPE\" INTEGER," + // 12: limitType
                "\"FOOD_SUMMARY\" INTEGER," + // 13: foodSummary
                "\"INVISIBLE\" INTEGER," + // 14: invisible
                "\"AUTO_MOD\" INTEGER," + // 15: autoMod
                "\"PRICE\" REAL," + // 16: price
                "\"MARKET_PRICE\" REAL," + // 17: marketPrice
                "\"LUNCHBOX_PRICE\" REAL," + // 18: lunchboxPrice
                "\"IMG_URL_SMALL\" TEXT," + // 19: imgUrlSmall
                "\"IMAGEURL\" TEXT," + // 20: imageurl
                "\"RICEPON_INVISIBLE\" INTEGER," + // 21: riceponInvisible
                "\"COST\" REAL," + // 22: cost
                "\"START_DATE\" INTEGER," + // 23: startDate
                "\"END_DATE\" INTEGER," + // 24: endDate
                "\"LIKE\" INTEGER," + // 25: like
                "\"TOTAL_SOLD\" INTEGER," + // 26: totalSold
                "\"IS_SOLD\" INTEGER," + // 27: isSold
                "\"CREATE_BY\" TEXT," + // 28: createBy
                "\"CREATE_TIME\" INTEGER," + // 29: createTime
                "\"UPDATE_BY\" TEXT," + // 30: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 31: updateTime
                "\"PERIOD_ID\" INTEGER," + // 32: periodId
                "\"ABLE_DISCOUNT\" INTEGER," + // 33: ableDiscount
                "\"TAKEAWAY\" INTEGER," + // 34: takeaway
                "\"BLUE_EDIT\" INTEGER," + // 35: blueEdit
                "\"CART_EDIT\" INTEGER," + // 36: cartEdit
                "\"AUTO_MERGE\" INTEGER," + // 37: autoMerge
                "\"PRINT_SETING\" TEXT," + // 38: printSeting
                "\"IS_PRINT_QUEUE_CODE\" INTEGER," + // 39: isPrintQueueCode
                "\"QUEUE_HEAD_ID\" INTEGER," + // 40: queueHeadId
                "\"APPROVE\" INTEGER," + // 41: approve
                "\"PRINT_FONT\" INTEGER," + // 42: printFont
                "\"ADV_PRICE\" INTEGER," + // 43: advPrice
                "\"PRINT_TO_BILL\" INTEGER," + // 44: printToBill
                "\"POINTS_ADD\" REAL," + // 45: pointsAdd
                "\"POINTS_RATIO\" INTEGER," + // 46: pointsRatio
                "\"POINTS_REDEEM\" REAL," + // 47: pointsRedeem
                "\"KT_PRINT_MAIN_ITEM\" INTEGER," + // 48: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER," + // 49: ktShowPrice
                "\"PRINT_TO\" INTEGER," + // 50: printTo
                "\"TO_PAX\" INTEGER," + // 51: toPax
                "\"FOOD_TYPE\" INTEGER," + // 52: foodType
                "\"MAJOR_MAIN_ID\" INTEGER," + // 53: majorMainId
                "\"DEPT_ID\" INTEGER," + // 54: deptId
                "\"SERVICE_CHARGE\" INTEGER," + // 55: serviceCharge
                "\"COLOR_ID\" INTEGER," + // 56: colorId
                "\"CONDITIONS\" INTEGER," + // 57: conditions
                "\"IS_RT\" INTEGER," + // 58: isRt
                "\"DELETES\" INTEGER," + // 59: deletes
                "\"IS_TIMING_FOOD\" INTEGER," + // 60: isTimingFood
                "\"MIN_LONG_TIME\" INTEGER," + // 61: minLongTime
                "\"UNIT_TIME\" INTEGER," + // 62: unitTime
                "\"UNIT_PRICE\" REAL," + // 63: unitPrice
                "\"FREE_LONG_TIME\" INTEGER," + // 64: freeLongTime
                "\"FREE_PERIOD_BEGIN\" INTEGER," + // 65: freePeriodBegin
                "\"IS_STATISTIC\" INTEGER);"); // 66: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(2, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(3, restaurantId);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(4, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(5, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(10, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(11, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(12, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(13, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(14, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(15, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(16, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(17, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(18, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(19, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(20, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(21, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(22, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(23, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(24, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(25, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(26, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(27, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(28, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(29, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(30, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(31, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(32, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(33, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(34, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(35, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(36, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(37, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(38, autoMerge);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(39, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(40, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(41, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(42, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(43, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(44, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(45, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(46, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(47, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(48, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(49, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(50, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(51, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(52, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(53, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(54, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(55, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(56, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(57, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(58, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(59, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(60, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(61, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(62, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(63, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(64, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(65, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(67, isStatistic);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(2, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(3, restaurantId);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(4, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(5, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(6, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(7, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(8, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(9, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(10, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(11, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(12, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(13, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(14, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(15, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(16, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(17, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(18, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(19, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(20, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(21, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(22, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(23, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(24, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(25, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(26, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(27, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(28, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(29, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(30, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(31, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(32, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(33, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(34, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(35, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(36, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(37, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(38, autoMerge);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(39, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(40, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(41, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(42, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(43, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(44, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(45, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(46, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(47, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(48, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(49, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(50, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(51, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(52, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(53, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(54, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(55, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(56, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(57, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(58, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(59, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(60, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(61, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(62, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(63, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(64, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(65, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(66, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(67, isStatistic);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // parentId
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // restaurantId
            cursor.isNull(offset + 3) ? null : (byte) cursor.getShort(offset + 3), // isParent
            cursor.isNull(offset + 4) ? null : cursor.getLong(offset + 4), // seqNo
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // foodName
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // foodName1
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // foodName2
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // plu
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // posFid
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // foodDesc
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11), // limitAmount
            cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12), // limitType
            cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13), // foodSummary
            cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14), // invisible
            cursor.isNull(offset + 15) ? null : (byte) cursor.getShort(offset + 15), // autoMod
            cursor.isNull(offset + 16) ? null : cursor.getDouble(offset + 16), // price
            cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17), // marketPrice
            cursor.isNull(offset + 18) ? null : cursor.getDouble(offset + 18), // lunchboxPrice
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // imgUrlSmall
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // imageurl
            cursor.isNull(offset + 21) ? null : cursor.getLong(offset + 21), // riceponInvisible
            cursor.isNull(offset + 22) ? null : cursor.getDouble(offset + 22), // cost
            cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)), // startDate
            cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)), // endDate
            cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25), // like
            cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26), // totalSold
            cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27), // isSold
            cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28), // createBy
            cursor.isNull(offset + 29) ? null : new java.util.Date(cursor.getLong(offset + 29)), // createTime
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // updateBy
            cursor.isNull(offset + 31) ? null : new java.util.Date(cursor.getLong(offset + 31)), // updateTime
            cursor.isNull(offset + 32) ? null : cursor.getLong(offset + 32), // periodId
            cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33), // ableDiscount
            cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34), // takeaway
            cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35), // blueEdit
            cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36), // cartEdit
            cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37), // autoMerge
            cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38), // printSeting
            cursor.isNull(offset + 39) ? null : cursor.getLong(offset + 39), // isPrintQueueCode
            cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40), // queueHeadId
            cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41), // approve
            cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42), // printFont
            cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43), // advPrice
            cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44), // printToBill
            cursor.isNull(offset + 45) ? null : cursor.getDouble(offset + 45), // pointsAdd
            cursor.isNull(offset + 46) ? null : cursor.getLong(offset + 46), // pointsRatio
            cursor.isNull(offset + 47) ? null : cursor.getDouble(offset + 47), // pointsRedeem
            cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48), // ktPrintMainItem
            cursor.isNull(offset + 49) ? null : cursor.getLong(offset + 49), // ktShowPrice
            cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50), // printTo
            cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51), // toPax
            cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52), // foodType
            cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53), // majorMainId
            cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54), // deptId
            cursor.isNull(offset + 55) ? null : (byte) cursor.getShort(offset + 55), // serviceCharge
            cursor.isNull(offset + 56) ? null : cursor.getLong(offset + 56), // colorId
            cursor.isNull(offset + 57) ? null : cursor.getLong(offset + 57), // conditions
            cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58), // isRt
            cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59), // deletes
            cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60), // isTimingFood
            cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61), // minLongTime
            cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62), // unitTime
            cursor.isNull(offset + 63) ? null : cursor.getDouble(offset + 63), // unitPrice
            cursor.isNull(offset + 64) ? null : cursor.getLong(offset + 64), // freeLongTime
            cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)), // freePeriodBegin
            cursor.isNull(offset + 66) ? null : cursor.getLong(offset + 66) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setParentId(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setRestaurantId(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setIsParent(cursor.isNull(offset + 3) ? null : (byte) cursor.getShort(offset + 3));
        entity.setSeqNo(cursor.isNull(offset + 4) ? null : cursor.getLong(offset + 4));
        entity.setFoodName(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setFoodName1(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setFoodName2(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setPlu(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setPosFid(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setFoodDesc(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setLimitAmount(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
        entity.setLimitType(cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12));
        entity.setFoodSummary(cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13));
        entity.setInvisible(cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14));
        entity.setAutoMod(cursor.isNull(offset + 15) ? null : (byte) cursor.getShort(offset + 15));
        entity.setPrice(cursor.isNull(offset + 16) ? null : cursor.getDouble(offset + 16));
        entity.setMarketPrice(cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17));
        entity.setLunchboxPrice(cursor.isNull(offset + 18) ? null : cursor.getDouble(offset + 18));
        entity.setImgUrlSmall(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setImageurl(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setRiceponInvisible(cursor.isNull(offset + 21) ? null : cursor.getLong(offset + 21));
        entity.setCost(cursor.isNull(offset + 22) ? null : cursor.getDouble(offset + 22));
        entity.setStartDate(cursor.isNull(offset + 23) ? null : new java.util.Date(cursor.getLong(offset + 23)));
        entity.setEndDate(cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)));
        entity.setLike(cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25));
        entity.setTotalSold(cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26));
        entity.setIsSold(cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27));
        entity.setCreateBy(cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28));
        entity.setCreateTime(cursor.isNull(offset + 29) ? null : new java.util.Date(cursor.getLong(offset + 29)));
        entity.setUpdateBy(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setUpdateTime(cursor.isNull(offset + 31) ? null : new java.util.Date(cursor.getLong(offset + 31)));
        entity.setPeriodId(cursor.isNull(offset + 32) ? null : cursor.getLong(offset + 32));
        entity.setAbleDiscount(cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33));
        entity.setTakeaway(cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34));
        entity.setBlueEdit(cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35));
        entity.setCartEdit(cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36));
        entity.setAutoMerge(cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37));
        entity.setPrintSeting(cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38));
        entity.setIsPrintQueueCode(cursor.isNull(offset + 39) ? null : cursor.getLong(offset + 39));
        entity.setQueueHeadId(cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40));
        entity.setApprove(cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41));
        entity.setPrintFont(cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42));
        entity.setAdvPrice(cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43));
        entity.setPrintToBill(cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44));
        entity.setPointsAdd(cursor.isNull(offset + 45) ? null : cursor.getDouble(offset + 45));
        entity.setPointsRatio(cursor.isNull(offset + 46) ? null : cursor.getLong(offset + 46));
        entity.setPointsRedeem(cursor.isNull(offset + 47) ? null : cursor.getDouble(offset + 47));
        entity.setKtPrintMainItem(cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48));
        entity.setKtShowPrice(cursor.isNull(offset + 49) ? null : cursor.getLong(offset + 49));
        entity.setPrintTo(cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50));
        entity.setToPax(cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51));
        entity.setFoodType(cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52));
        entity.setMajorMainId(cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53));
        entity.setDeptId(cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54));
        entity.setServiceCharge(cursor.isNull(offset + 55) ? null : (byte) cursor.getShort(offset + 55));
        entity.setColorId(cursor.isNull(offset + 56) ? null : cursor.getLong(offset + 56));
        entity.setConditions(cursor.isNull(offset + 57) ? null : cursor.getLong(offset + 57));
        entity.setIsRt(cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58));
        entity.setDeletes(cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59));
        entity.setIsTimingFood(cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60));
        entity.setMinLongTime(cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61));
        entity.setUnitTime(cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62));
        entity.setUnitPrice(cursor.isNull(offset + 63) ? null : cursor.getDouble(offset + 63));
        entity.setFreeLongTime(cursor.isNull(offset + 64) ? null : cursor.getLong(offset + 64));
        entity.setFreePeriodBegin(cursor.isNull(offset + 65) ? null : new java.util.Date(cursor.getLong(offset + 65)));
        entity.setIsStatistic(cursor.isNull(offset + 66) ? null : cursor.getLong(offset + 66));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
