package com.gingersoft.gsa.cloud.globalconfig;

import android.app.Application;
import android.content.Context;
import com.gingersoft.gsa.cloud.base.utils.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyGlobalHttpHandler;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyGsonConfiguration;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyOkhttpConfiguration;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyResponseErrorListener;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyRetrofitConfiguration;
import com.gingersoft.gsa.cloud.globalconfig.applyOptions.MyRxCacheConfiguration;
import com.gingersoft.gsa.cloud.globalconfig.lifecyclesOptioins.MyActivityLifecycle;
import com.gingersoft.gsa.cloud.globalconfig.lifecyclesOptioins.MyAppLifecycles;
import com.jess.arms.base.delegate.AppLifecycles;
import com.jess.arms.di.module.GlobalConfigModule;
import com.jess.arms.integration.ConfigModule;
import com.jess.arms.utils.DataHelper;
import java.io.File;
import java.util.List;

import androidx.fragment.app.FragmentManager;

public class GlobalConfiguration implements ConfigModule {

    @Override
    public void applyOptions(Context context, GlobalConfigModule.Builder builder) {
        //使用builder可以为框架配置一些配置信息
        builder
                .baseurl(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL)
                .okhttpConfiguration(new MyOkhttpConfiguration())
                .retrofitConfiguration(new MyRetrofitConfiguration())
                .globalHttpHandler(new MyGlobalHttpHandler())
                .rxCacheConfiguration(new MyRxCacheConfiguration())
                .responseErrorListener(new MyResponseErrorListener())
                .cacheFile(new File(DataHelper.getCacheFile(context), "rxCache"))
                .gsonConfiguration(new MyGsonConfiguration());
    }

    @Override
    public void injectAppLifecycle(Context context, List<AppLifecycles> lifecycles) {
        //向Application的生命周期中注入一些自定义逻辑
        lifecycles.add(new MyAppLifecycles());
    }


    @Override
    public void injectActivityLifecycle(Context context, List<Application.ActivityLifecycleCallbacks> lifecycles) {
        //向Activity的生命周期中注入一些自定义逻辑
        lifecycles.add(new MyActivityLifecycle());
    }


    @Override
    public void injectFragmentLifecycle(Context context, List<FragmentManager.FragmentLifecycleCallbacks> lifecycles) {
        //向Fragment的生命周期中注入一些自定义逻辑
    }


}