package com.gingersoft.gsa.cloud.ui.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionImageItem;
import com.gingersoft.gsa.cloud.ui.view.BaseTextSection;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import androidx.annotation.NonNull;
import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-09
 * 修订历史：2020-02-09
 * 描述：
 */
public class BaseImageSectiontAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, SectionImageItem> {

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new BaseTextSection(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.iu_item_base_image_section, null));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionImageItem> section) {
        super.onBindSectionHeader(holder, position, section);
        BaseTextSection itemView = (BaseTextSection) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionImageItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;
        viewHolder.iv_icon.setImageResource(section.getItemAt(itemIndex).getImage());
    }

    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.iv_icon)
        ImageView iv_icon;//功能名
        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public ImageView getIcon() {
            return iv_icon;
        }
    }
}
