package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Application;
import android.content.Context;

import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.TableAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.AllTableFragment;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.AllTableContract;
import com.jess.arms.utils.DeviceUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class AllTablePresenter extends BasePresenter<AllTableContract.Model, AllTableContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private TableActivity mActivity;
    private AllTableFragment IView;

    private TableAdapter mTableAdapter;
    private List<TableBean.DataBean> mTableList = new ArrayList<>();


    @Inject
    public AllTablePresenter(AllTableContract.Model model, AllTableContract.View rootView) {
        super(model, rootView);
        this.IView = (AllTableFragment) rootView;
        this.mActivity = (TableActivity) IView.getActivity();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initTableAdapter(Context context) {
        if (mTableAdapter == null) {
            mTableAdapter = new TableAdapter(context, mTableList, DeviceUtils.getScreenHeight(mApplication), TableActivity.FUNCTION_ALL_TABLE);
            mTableAdapter.setStyle(0);
            mRootView.setAllTableAdapter(mTableAdapter);
            initItemClickListener(context);
        }
    }

    private void initItemClickListener(Context context) {
        mTableAdapter.setOnItemClickListener(new TableAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(TableBean.DataBean item, int position) {

                VibratorUtils.pressButtonSound(mApplication);

                mActivity.clickTableItem(item);
            }
        });
    }

    public void updateAllTableData(Context context, List<TableBean.DataBean> tableList) {
        if (tableList != null) {
            mTableList.clear();
            initTableByZoneId(tableList);
            initTableAdapter(context);
            mTableAdapter.notifyDataSetChanged();
        }
    }

    private void initTableByZoneId(List<TableBean.DataBean> tableList) {
//        int zoneId = GSAApplication.tableContract.getZoneid();
//        if (zoneId == -1) {
        mTableList.addAll(tableList);
//        } else {
//            for (TableBean.DataBean datasBean : tableList) {
//                // 获取当前ID的区域
//                if (datasBean.getZoneid() == zoneId) {
//                    mTableList.add(datasBean);
//                }
//            }
//        }
    }


    /**
     * 更新状态以改变餐台
     *
     * @param newTableList
     */
    public void updataTableItem(List<TableBean.DataBean> newTableList) {
        for (int i = 0; i < newTableList.size(); i++) {
            TableBean.DataBean newTableBean = newTableList.get(i);
            for (int j = 0; j < mTableList.size(); j++) {
                TableBean.DataBean tableBean = mTableList.get(j);
                if (tableBean.getId() == newTableBean.getId()) {
//                    tableBean.setOrderid(newTableBean.getOrderid());
//                    tableBean.setOrderid_1(newTableBean.getOrderid_1());
//                    tableBean.setStatus(newTableBean.getStatus());
//                    tableBean.setUsing(newTableBean.isUsing());
//                    tableBean.setMainshowtable(newTableBean.getMainshowtable());
//                    tableBean.setSplitStatus(newTableBean.getSplitStatus());
//                    tableBean.setOropentime_diff(newTableBean.getOropentime_diff());
//                    tableBean.setPrtime_diff(newTableBean.getPrtime_diff());
//                    tableBean.setClearstate(newTableBean.getClearstate());
//                    tableBean.setOpentime(newTableBean.getOpentime());
//                    tableBean.setMemid(newTableBean.getMemid());
//                    tableBean.setSc_rate(newTableBean.getSc_rate());
//                    tableBean.setPax(newTableBean.getPax());
//                    tableBean.setQr_code(newTableBean.getQr_code());
//                    tableBean.setRiceponorderid(newTableBean.getRiceponorderid());

                    mTableAdapter.notifyItemChanged(j);
                }
            }
        }
    }
}
