package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class OrderTopFunctionAdapter extends DefaultAdapter<Function> {

    private Context mContext;
    private int detailCol = 3;

    public OrderTopFunctionAdapter(Context context, List<Function> infos) {
        super(infos);
        this.mContext = context;

    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Function> getHolder(View v, int viewType) {
        return new TopFunctionItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_order_top_function;
    }

    class TopFunctionItemHolder extends BaseHolder<Function> {

        @BindView(R2.id.btn_name)
        QMUIAlphaButton btn_name;

        public TopFunctionItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Function datasBean, int position) {

            btn_name.setText(datasBean.getResName());
            btn_name.setTextColor(datasBean.getTextColor());
            btn_name.setBackgroundColor(datasBean.getBackgroundColor());
            btn_name.setTextSize(datasBean.getTextSize());

            ViewGroup.LayoutParams layoutParams = btn_name.getLayoutParams();
            layoutParams.width = QMUIDisplayHelper.getScreenWidth(mContext) / detailCol;
            btn_name.setLayoutParams(layoutParams);
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Function datasBean, int position);

    }
}
