package com.gingersoft.gsa.cloud.user.login.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.utils.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.user.login.R;
import com.gingersoft.gsa.cloud.user.login.R2;
import com.gingersoft.gsa.cloud.user.login.di.component.DaggerSwitchServerComponent;
import com.gingersoft.gsa.cloud.user.login.mvp.contract.SwitchServerContract;
import com.gingersoft.gsa.cloud.user.login.mvp.presenter.SwitchServerPresenter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/29/2020 20:49
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SwitchServerActivity extends BaseActivity<SwitchServerPresenter> implements SwitchServerContract.View {

    @BindView(R2.id.rb_server_sz)
    RadioButton rbSZ;
    @BindView(R2.id.rb_server_hk)
    RadioButton rbHK;
    @BindView(R2.id.btn_switch_server)
    Button switchServer;
    @BindView(R2.id.tv_now_server)
    TextView tvNowServer;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSwitchServerComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_switch_server; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    ///RetrofitUrlManager.getInstance().putDomain("common", HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL);
    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        String nowServer = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL;
        tvNowServer.setText("當前服務器：" + nowServer);
        rbHK.setText("香港服務器：" + HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL_HK);
        rbSZ.setText("深圳服務器：" + HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL_SZ);
        if (nowServer.equals(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL_SZ)) {
            rbSZ.setChecked(true);
        } else {
            rbHK.setChecked(true);
        }
        switchServer.setOnClickListener(v -> {
            if (rbSZ.isChecked()) {
                HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL_SZ;
            } else {
                HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL_HK;
            }
            finish();
            startActivity(new Intent(mContext, LoginActivity.class));
        });
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
