package com.gingersoft.supply_chain.mvp.content;

import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;
import com.xuexiang.rxutil2.rxjava.task.RxIOTask;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:21
 * Use: 供應鏈購物車,需要緩存用戶選中的食品
 */
public class SupplyShoppingCart {
    /**
     * key為食品id
     * value為食品信息
     */
    private static List<PurchaseFoodBean> cartFoods;

    private static SupplyShoppingCart shoppingCart;

    public static SupplyShoppingCart getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new SupplyShoppingCart();
        }
        return shoppingCart;
    }

    public List<PurchaseFoodBean> getCartFoods() {
        if (cartFoods == null) {
            cartFoods = new ArrayList<>();
        }
        return cartFoods;
    }

    public void clear() {
        if (cartFoods == null) {
            return;
        }
        cartFoods.clear();
        cartFoods = null;
    }


    public void removeFoodsByFoodId(int foodId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getId() != null && next.getId() == foodId) {
                        iterator.remove();
                        break;
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsBySupplier(int supplierId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getSupplierId() != null && next.getSupplierId() == supplierId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryId(int categoryId) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除供應商成功後，需要從購物車數據中將這個供應商的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == categoryId) {
                        iterator.remove();
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
        RxJavaUtils.doInIOThread(new RxIOTask<Object>(0) {
            @Override
            public Void doInIOThread(Object o) {
                //刪除分類成功後，需要從購物車數據中將這個分類的食材都刪除掉
                List<PurchaseFoodBean> cartFoods = SupplyShoppingCart.getInstance().getCartFoods();
                Iterator<PurchaseFoodBean> iterator = cartFoods.iterator();
                while (iterator.hasNext()) {
                    PurchaseFoodBean next = iterator.next();
                    if (next.getFoodCategoryId() != null && next.getFoodCategoryId() == foodCategoryTrees.getId()) {
                        iterator.remove();
                    }
                }
                //分類中的刪除完了，需要刪除分類下子分類的食材
                List<OrderCategoryBean.FoodCategoryTrees> childCategory = foodCategoryTrees.getFoodCategoryTrees();
                if (childCategory != null) {
                    //遍歷二級分類
                    for (OrderCategoryBean.FoodCategoryTrees categoryTrees : childCategory) {
                        for (PurchaseFoodBean cartFood : cartFoods) {
                            if (cartFood.getFoodCategoryId() == categoryTrees.getId()) {
                                cartFoods.remove(cartFood);
                                break;
                            }
                        }
                        //對三級分類進行遍歷
                        List<OrderCategoryBean.FoodCategoryTrees> thirdCategory = categoryTrees.getFoodCategoryTrees();
                        removeFoodsByCategoryTress(thirdCategory);
                    }
                }
                return null;
            }
        });
    }

    public void removeFoodsByCategoryTress(List<OrderCategoryBean.FoodCategoryTrees> thirdCategory) {
        if (thirdCategory != null) {
            for (OrderCategoryBean.FoodCategoryTrees trees : thirdCategory) {
                for (PurchaseFoodBean cartFood : cartFoods) {
                    if (cartFood.getFoodCategoryId() == trees.getId()) {
                        cartFoods.remove(cartFood);
                    }
                }
            }
        }
    }


    public void setCartFoods(List<PurchaseFoodBean> cartFoods) {
        SupplyShoppingCart.cartFoods = cartFoods;
    }
}
