package com.gingersoft.gsa.cloud.common.logan;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.dianping.logan.Logan;
import com.dianping.logan.SendLogCallback;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.BuildConfig;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.common.config.LoganConfig;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:
 */
public class LoganManager {

    private static final String TAG = LoganManager.class.getSimpleName();

    public static void w_code(String TAG, String log) {
        Logan.w(log, LoganConfig.CODE_LEVLE);
        printLog(TAG, log);
    }

    public static void w_action(String TAG, String log) {
        Logan.w(log, LoganConfig.ACTION_LEVLE);
        printLog(TAG, log);
    }

    public static void w_network(String log) {
        Logan.w(log, LoganConfig.NETWORK_LEVLE);
        //網絡日誌比較重要立即寫入本地
//        Logan.f();
        if (BuildConfig.DEBUG) {
            printLog("network", log);
        }
    }

    public static void w_crash(String log) {
        Logan.w(log, LoganConfig.CRASH_LEVLE);
        //cash日誌比較重要立即寫入本地
        Logan.f();
        printLog("AppCrashHandler", log);
    }

    public static void w_H5(String log) {
        Logan.w(log, LoganConfig.H5_LEVLE);
    }

    public static void w_native(String log) {
        Logan.w(log, LoganConfig.native_LEVLE);
    }

    public static void w_heart(String log) {
        Logan.w(log, LoganConfig.heart_LEVLE);
    }
    /*******************************自定義業務日誌類型**************************************/
    private static final String LOGIN_BUSINESS_TAG = "login-> ";
    private static final String HOME_BUSINESS_TAG = "home-> ";
    private static final String DATABASE_BUSINESS_TAG = "database-> ";
    private static final String PRINTER_BUSINESS_TAG = "printer-> ";
    private static final String TABLEMODE_BUSINESS_TAG = "tableMode-> ";
    private static final String ORDER_BUSINESS_TAG = "order-> ";
    private static final String PAY_BUSINESS_TAG = "pay-> ";
    private static final String DELIVERY_PICK_TAG = "delivery-> ";


    /*******************************交互事件類型**************************************/
    public static final String EVENT_CLICK = "點擊->";
    public static final String EVENT_LONG_CLICK = "長按->";
    public static final String EVENT_SELECTED = "選中->";
    public static final String EVENT_TOUCH = "觸摸->";
    public static final String EVENT_SCOLL = "滑動->";
    public static final String EVENT_RETRY = "重試加載->";
    public static final String EVENT_PULL_DOWN = "下拉刷新->";
    public static final String EVENT_PULL_UP = "上拉加載->";

    /*******************************業務事件類型**************************************/
    public static final String EVENT_CALCULATE = "計算->";
    public static final String EVENT_ADD = "添加->";
    public static final String EVENT_DELETE = "刪除->";
    public static final String EVENT_MODIFY = "修改->";
    public static final String EVENT_QUERY = "查詢->";

    public static void w_login(String TAG,String... eventAndLog) {
        w_business(LOGIN_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_home(String TAG,String... eventAndLog) {
        w_business(HOME_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_database(String TAG,String... eventAndLog) {
        w_business(DATABASE_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_printer(String TAG, String... eventAndLog) {
        w_business(PRINTER_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_tableMode(String TAG, String... eventAndLog) {
        w_business(TABLEMODE_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_order(String TAG, String... eventAndLog) {
        w_business(ORDER_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_pay(String TAG, String... eventAndLog) {
        w_business(PAY_BUSINESS_TAG, TAG, eventAndLog);
    }

    public static void w_delivery(String TAG, String... eventAndLog) {
        w_business(DELIVERY_PICK_TAG, TAG, eventAndLog);
    }
    private static void w_business(String BUSINESS_TAG, String TAG, String... eventAndLog) {
        if (eventAndLog != null) {
            if (eventAndLog.length > 1) {
                Logan.w(BUSINESS_TAG + eventAndLog[0] + eventAndLog[1], LoganConfig.CODE_LEVLE);
                printLog(TAG, eventAndLog[0] + eventAndLog[1]);
            } else {
                Logan.w(BUSINESS_TAG + eventAndLog[0], LoganConfig.CODE_LEVLE);
                printLog(TAG, eventAndLog[0]);
            }
        }
    }

    private static void printLog(String TAG, String log) {
        if (BuildConfig.DEBUG) {
            LogUtil.d(TAG, log);
        }
    }

    /**
     * 上傳日誌到服務器
     */
    public static void uploadLog(Context context, boolean showToast) {
        String memberId = UserContext.newInstance().getMemberName() + "_" + UserContext.newInstance().getMemberId();
        String deviceId = DeviceUtils.getDeviceId(GsaCloudApplication.getAppContext());
        String AppVersion = DeviceUtils.getVersionName(GsaCloudApplication.getAppContext()) + "_" + DeviceUtils.getVersionCode(GsaCloudApplication.getAppContext());
        String BuildVersion = android.os.Build.VERSION.RELEASE + "";
        Logan.s(LoganConfig.UPLOAD_LOG_URL, TimeUtils.getCurrentDate(TimeUtils.DATE_FORMAT_DATE), LoganConfig.APP_ID, memberId, deviceId,
                BuildVersion, AppVersion, new SendLogCallback() {
                    @Override
                    public void onLogSendCompleted(int statusCode, byte[] data) {
                        final String resultData = data != null ? new String(data) : "";
                        new Handler(Looper.getMainLooper()).post(new Runnable() {
                            @Override
                            public void run() {
                                if (BuildConfig.DEBUG && showToast) {
                                    if (statusCode == 200) {
                                        ArmsUtils.makeText(context, "日誌上傳成功");
                                    } else {
                                        ArmsUtils.makeText(context, "日誌上傳失敗");
                                    }
                                }
                            }
                        });
                        LoganManager.w_code(TAG, "上傳日誌到服務器: " + statusCode + ", details: " + resultData);
                    }
                });
    }
}
