package com.gingersoft.supply_chain.mvp.ui.adapter;

import androidx.appcompat.widget.AppCompatCheckBox;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.ConsumeReasonBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/18
 * Time: 18:06
 * Use: 庫存損耗原因
 */
public class ConsumptionReasonAdapter extends BaseQuickAdapter<ConsumeReasonBean, BaseViewHolder> {
    private int selectIndex = 0;

    public ConsumptionReasonAdapter(List<ConsumeReasonBean> consumeReasonBeans) {
        super(R.layout.item_consumption_reason, consumeReasonBeans);
        addChildClickViewIds(R.id.cb_consumption_reason);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, ConsumeReasonBean consumeReasonBean) {
        AppCompatCheckBox compatCheckBox = viewHolder.getView(R.id.cb_consumption_reason);
        compatCheckBox.setText(consumeReasonBean.getDescription());
        compatCheckBox.setChecked(viewHolder.getAdapterPosition() == selectIndex);
    }

    public int getSelectIndex() {
        return selectIndex;
    }

    public void setSelectIndex(int selectIndex) {
        int lastSelect = this.selectIndex;
        this.selectIndex = selectIndex;
        if (lastSelect < getData().size()) {
            notifyItemChanged(lastSelect);
        }
        if (this.selectIndex < getData().size()) {
            notifyItemChanged(this.selectIndex);
        }
    }
}

