package com.gingersoft.supply_chain.mvp.ui.widget;

import android.annotation.SuppressLint;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.jess.arms.utils.DeviceUtils;
import com.lxj.xpopup.core.BottomPopupView;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/18
 * Time: 10:01
 * Use: 掃描sn碼彈窗
 */
public class ScanSnPopup extends BottomPopupView {

    private final String foodName;
    private final List<String> snCodes;
    private final Fragment fragment;
    @BindView(R2.id.tv_food_Ingredients_name)
    TextView tvFoodIngredientsName;
    @BindView(R2.id.tv_food_inbound_quantity)
    TextView tvFoodInboundQuantity;
    @BindView(R2.id.layout_scan_sn)
    LinearLayout rootLayout;

    private OnScanResultListener onScanResultListener;

    public ScanSnPopup(@NonNull Fragment fragment, String foodName, List<String> snCodes, OnScanResultListener onScanResultListener) {
        super(fragment.requireContext());
        if (snCodes == null) {
            snCodes = new ArrayList<>();
        }
        this.foodName = foodName;
        this.snCodes = snCodes;
        this.fragment = fragment;
        this.onScanResultListener = onScanResultListener;
        addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.popup_scan_sn;
    }

    @Override
    @SuppressLint("ClickableViewAccessibility")
    protected void initPopupContent() {
        super.initPopupContent();
        ButterKnife.bind(this);
        tvFoodIngredientsName.setText(foodName);
        tvFoodInboundQuantity.setText(String.valueOf(snCodes.size()));
        rootLayout.addView(new ScanSnView(fragment, snCodes, onScanResultListener).setOnCancelListener(() -> dismiss()));
    }

    @Override
    protected int getMaxHeight() {
        return (int) (DeviceUtils.getScreenHeight(getContext()) / 2);
    }

    @Override
    protected int getPopupHeight() {
        return (int) (DeviceUtils.getScreenHeight(getContext()) / 2);
    }

    public interface OnScanResultListener {
        /**
         * 掃完碼確認之後回調
         *
         * @param scanResult 本次掃碼結果
         */
        void onScanResult(List<String> scanResult);
    }


}
