package com.gingersoft.gsa.cloud.pay;

import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.pay.device.pos.PosCommand;
import com.gingersoft.gsa.cloud.pay.device.pos.bbpos.BBPosCommandImp;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.HywebCommandImp;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.YedpayCommandImp;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:28
 * @更新時間: 2021-04-14 12:28
 * @描述:
 */
public class PaymentFactory {

    public static PosCommand createPosCommand() {
        if (AppDevices.isHywebPos()) {
            return HywebCommandImp.newInstance();
        } else if (AppDevices.isBBPos()) {
            return BBPosCommandImp.newInstance();
        } else if (AppDevices.isYedpay()) {
            return YedpayCommandImp.newInstance();
        }
        return YedpayCommandImp.newInstance();
    }

}
