package com.joe.print.mvp.ui.adapter;

import android.widget.RadioButton;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;

import java.util.List;

public class SelectPrintAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {

    private int selectPosion = 0;

    public SelectPrintAdapter(@Nullable List<PrinterDeviceBean> data) {
        super(R.layout.item_dialog_select_print, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        helper.setText(R.id.tv_item_print_name, item.getName() + "");
        RadioButton rb = helper.getView(R.id.rb_item_print);
        rb.setChecked(helper.getAdapterPosition() == selectPosion);
    }

    public int getSelectPosion() {
        return selectPosion;
    }

    public void setSelectPosion(int selectPosion) {
        this.selectPosion = selectPosion;
        notifyDataSetChanged();
    }
}
