package com.gingersoft.gsa.cloud.login.mvp.presenter;

import android.app.Application;
import android.text.TextUtils;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.oaId.DeviceID;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.mvp.contract.LoginContract;
import com.gingersoft.gsa.cloud.login.mvp.ui.activity.LoginActivity;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.PermissionUtil;
import com.tbruyelle.rxpermissions2.RxPermissions;
import java.util.List;
import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/21/2019 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class LoginPresenter extends BaseLoginPresenter<LoginContract.Model, LoginContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private LoginActivity IAcitivty;

    @Inject
    public LoginPresenter(LoginContract.Model model, LoginContract.View rootView) {
        super(model, rootView);
        IAcitivty = (LoginActivity) rootView;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    /**
     * 进入应用强制用户开启 存储的权限(保存error log来文件必须拥有读写权限)
     */
    public void requestExternalStoragePermission() {
        PermissionUtil.externalStorage(new PermissionUtil.RequestPermission() {
            @Override
            public void onRequestPermissionSuccess() {
                if (TextUtils.isEmpty(DeviceID.getDeviceId())) {
                    //獲取權限成功重新獲取deviceId
                    GsaCloudApplication.initDeviceId();
                }
            }

            @Override
            public void onRequestPermissionFailure(List<String> permissions) {
                mRootView.showMessage(LanguageUtils.get_language_system( "external.storage.permission.hint", ArmsUtils.getString(mApplication, R.string.queue_write_external_storage_permission_hint)));
                mRootView.killMyself();
            }

            @Override
            public void onRequestPermissionFailureWithAskNeverAgain(List<String> permissions) {
                mRootView.showMessage(LanguageUtils.get_language_system( "external.storage.permission.hint", ArmsUtils.getString(mApplication, R.string.queue_write_external_storage_permission_hint)));
                mRootView.killMyself();
            }
        }, new RxPermissions(IAcitivty), mErrorHandler);
    }

//    public void login(String account, String pwd) {
//        if (account.equals("88888888") && pwd.equals("cc81081168")) {
//            mRootView.startToSwitchServer();
//            return;
//        }
//        RequestBody requestBody;
//        requestBody = new FormBody.Builder()
//                .add("userName", account.trim() + "")
//                .add("passWord", pwd.trim() + "")
//                .build();
//        mModel.login(requestBody)
//                .subscribeOn(Schedulers.io())
//                .doOnSubscribe(disposable -> mRootView.showLoading("登錄中..."))
//                .subscribeOn(AndroidSchedulers.mainThread())
//                .observeOn(AndroidSchedulers.mainThread())
//                .doAfterTerminate(() -> mRootView.hideLoading())
//                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
//                .subscribe(new ErrorHandleSubscriber<LoginBean>(mErrorHandler) {
//
//                    @Override
//                    public void onNext(@NonNull LoginBean info) {
//                        if (info.isSuccess()) {
//                            GsaCloudApplication.isLogin = true;
//                            GsaCloudApplication.userName = info.getData().getUser().getUserName();
//                            mRootView.showMessage("登陸成功");
//                            mRootView.loginSuccess(info);
//                        } else {
//                            GsaCloudApplication.isLogin = false;
//                            mRootView.showMessage(info.getErrMsg());
//                        }
//                    }
//                });
//    }
}
