package com.gingersoft.gsa.cloud.database.utils;//package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.greendao.PrinterDeviceBeanDao;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class PrinterDeviceDaoUtils {

    private static final String TAG = PrinterDeviceDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public PrinterDeviceDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }


    /**
     * 完成PrinterDeviceBean记录的插入，如果表未创建，先创建PrinterDeviceBean表
     * @return
     */
    public boolean insertPrinterDeviceBean(PrinterDeviceBean printerDevice){
        boolean flag = false;
        flag = mManager.getDaoSession().getPrinterDeviceBeanDao().insert(printerDevice) == -1 ? false : true;
        Log.i(TAG, "insert printerDevice :" + flag + "-->" + printerDevice.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     * @param printerDeviceList
     * @return
     */
    public boolean insertMultPrinterDeviceBean(final List<PrinterDeviceBean> printerDeviceList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (PrinterDeviceBean PrinterDeviceBean : printerDeviceList) {
                        mManager.getDaoSession().insertOrReplace(PrinterDeviceBean);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     * @param printerDevice
     * @return
     */
    public boolean updatePrinterDeviceBean(PrinterDeviceBean printerDevice){
        boolean flag = false;
        try {
            mManager.getDaoSession().update(printerDevice);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     * @param printerDevice
     * @return
     */
    public boolean deletePrinterDeviceBean(PrinterDeviceBean printerDevice){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(printerDevice);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     * @return
     */
    public boolean deleteAll(){
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(PrinterDeviceBean.class);
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     * @return
     */
    public List<PrinterDeviceBean> queryAllPrinterDeviceBean(){
        return mManager.getDaoSession().loadAll(PrinterDeviceBean.class);
    }

    /**
     * 根据主键id查询记录
     * @param key
     * @return
     */
    public PrinterDeviceBean queryPrinterDeviceBeanById(long key){
        return mManager.getDaoSession().load(PrinterDeviceBean.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<PrinterDeviceBean> queryPrinterDeviceBeanByNativeSql(String sql, String[] conditions){
        return mManager.getDaoSession().queryRaw(PrinterDeviceBean.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询
     * @return
     */
    public List<PrinterDeviceBean> queryPrinterDeviceBeanByQueryBuilder(long PrinterDeviceBeanId){
        QueryBuilder<PrinterDeviceBean> queryBuilder = mManager.getDaoSession().queryBuilder(PrinterDeviceBean.class);
        return queryBuilder.where(PrinterDeviceBeanDao.Properties.Id.eq(PrinterDeviceBeanId)).list();
    }


}
