package com.gingersoft.gsa.cloud.function;


import android.content.Context;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.utils.FunctionDaoUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-10
 * 修订历史：2020-04-10
 * 描述：功能管理
 */
public class FunctionManager {

    private String TAG = getClass().getSimpleName();
    private static FunctionManager sDefaultOpenTableManage;

    public static FunctionManager getDefault() {
        if (sDefaultOpenTableManage == null) {
            sDefaultOpenTableManage = new FunctionManager();
        }
        return sDefaultOpenTableManage;
    }


    public List<Function> getFunctionByResModule(Context context, Class c, FModule[] fModules, String specific) {

        String resLoction = c.getSimpleName().toLowerCase() + "/" + specific;

        FunctionDaoUtils daoUtils = new FunctionDaoUtils(context);
        List<Function> functionList = daoUtils.queryAllFunction();
        return filterFunctionByResLoction(functionList, fModules, resLoction);
    }

    private List<Function> filterFunctionByResLoction(List<Function> functionList, FModule[] fModules, String resLoction) {
        List<Function> functions = new ArrayList<>();
        for (int i = 0; i < functionList.size(); i++) {
            Function function = functionList.get(i);
            if (function.getResUrl().startsWith(resLoction)) {
                for (int j = 0; j < fModules.length; j++) {
                    FModule module = fModules[j];
                    if(function.getResUrl().equals(module.getKeyRes())){
                        if (function.getStatus() == 0) {
                            function.setIconRes(module.getOpenIconRes());
                        } else {
                            function.setIconRes(module.getDisableIconRes());
                        }
                    }
                }
                functions.add(function);
            }
        }
        return functions;
    }


}
