package com.gingersoft.gsa.cloud.manager.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.gingersoft.gsa.cloud.manager.R2;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.manager.di.component.DaggerAddTableComponent;
import com.gingersoft.gsa.cloud.manager.mvp.contract.AddTableContract;
import com.gingersoft.gsa.cloud.manager.mvp.presenter.AddTablePresenter;
import com.gingersoft.gsa.cloud.manager.R;
import com.qmuiteam.qmui.util.QMUIDeviceHelper;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUILoadingView;
import com.qmuiteam.qmui.widget.grouplist.QMUICommonListItemView;
import com.qmuiteam.qmui.widget.grouplist.QMUIGroupListView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import butterknife.BindDimen;
import butterknife.BindView;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/14/2020 10:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class AddTableFragment extends BaseFragment<AddTablePresenter> implements AddTableContract.View {

    @BindView(R2.id.groupListView)
    QMUIGroupListView mGroupListView;


    public static AddTableFragment newInstance() {
        AddTableFragment fragment = new AddTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerAddTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_add_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initGroupListView();
    }


    private void initGroupListView() {

        int height = QMUIResHelper.getAttrDimen(getContext(), com.qmuiteam.qmui.R.attr.qmui_list_item_height);

        QMUICommonListItemView itemRedPoint4 = mGroupListView.createItemView(null,
                "區域",
                "大廳",
                QMUICommonListItemView.HORIZONTAL,
                QMUICommonListItemView.ACCESSORY_TYPE_CHEVRON,
                height);
        itemRedPoint4.setTipPosition(QMUICommonListItemView.TIP_POSITION_RIGHT);


        QMUICommonListItemView tableNameItemView = mGroupListView.createItemView("餐檯名稱");
        tableNameItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        EditText tableNameEditText = new EditText(getActivity());
        tableNameEditText.setHint("必填");
        tableNameEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        tableNameEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        tableNameItemView.addAccessoryCustomView(tableNameEditText);

        QMUICommonListItemView peopleNumberItemView = mGroupListView.createItemView("就餐人數");
        peopleNumberItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        EditText peopleNumberEditText = new EditText(getActivity());
        peopleNumberEditText.setHint("必填");
        peopleNumberEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        peopleNumberEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        peopleNumberItemView.addAccessoryCustomView(peopleNumberEditText);


        QMUICommonListItemView serverchargeItemView = mGroupListView.createItemView("服務費");
        serverchargeItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        EditText serverchargeEditText = new EditText(getActivity());
        serverchargeEditText.setHint("0");
        serverchargeEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        serverchargeEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        serverchargeItemView.addAccessoryCustomView(serverchargeEditText);


        QMUICommonListItemView tableSortItemView = mGroupListView.createItemView("餐桌排序");
        tableSortItemView.setAccessoryType(QMUICommonListItemView.ACCESSORY_TYPE_CUSTOM);
        EditText tableSortEditText = new EditText(getActivity());
        tableSortEditText.setHint("100");
        tableSortEditText.setTextSize(QMUIDisplayHelper.dpToPx(8));
        tableSortEditText.setBackgroundColor(ContextCompat.getColor(mContext, R.color.trans));
        tableSortItemView.addAccessoryCustomView(tableSortEditText);


        int size = QMUIDisplayHelper.dp2px(getContext(), 20);
        QMUIGroupListView.newSection(getContext())
                .setLeftIconSize(size, ViewGroup.LayoutParams.WRAP_CONTENT)
                .addItemView(itemRedPoint4, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {

                    }
                })
                .addItemView(tableNameItemView, null)
                .addItemView(peopleNumberItemView, null)
                .addItemView(serverchargeItemView, null)
                .addItemView(tableSortItemView, null)
                .setMiddleSeparatorInset(QMUIDisplayHelper.dp2px(getContext(), 16), 0)
                .addTo(mGroupListView);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(mContext, message, true);
        else
            LoadingDialog.showDialogForLoading(mContext);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
