package com.gingersoft.gsa.cloud.ui.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.base.R;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by Wyh on 2019/9/20.
 */
public class SearchKeyBoardView extends FrameLayout {

    String[] number = new String[]{"7", "8", "9", "4", "5", "6", "1", "2", "3", "CLR", "0", "√"};

    String[] en = new String[26];

    private TextView tvInput;

    public SearchKeyBoardView(Context context) {
        super(context);
        init(context);
    }

    public SearchKeyBoardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public SearchKeyBoardView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        for (int i = 0; i < 26; i++) {
            en[i] = ((char) (65 + i)) + "";//输出A-Z 26个大写字母
        }

        View view = LayoutInflater.from(context).inflate(R.layout.ui_layout_search_keyborder, null);
        tvInput = view.findViewById(R.id.tv_keyboard_input);
        RecyclerView rvEn = view.findViewById(R.id.rv_keyboard_en);
        RecyclerView rvNumber = view.findViewById(R.id.rv_keyboard_number);

        rvEn.setLayoutManager(new LinearLayoutManager(context));

        rvEn.setAdapter(new KeyBoardAdapter(en).setBorder(false,false));

        rvNumber.setLayoutManager(new GridLayoutManager(context, 3));
        rvNumber.setAdapter(new KeyBoardAdapter(number));
        this.addView(view);

    }

    private onConfirmCallBack onConfirmCallBack;

    public interface onConfirmCallBack {
        void onCallBack(String inputText);
    }

    public void setOnConfirmCallBack(SearchKeyBoardView.onConfirmCallBack onConfirmCallBack) {
        this.onConfirmCallBack = onConfirmCallBack;
    }

    public class KeyBoardAdapter extends RecyclerView.Adapter<ViewHolder> {
        private String[] text;
        private boolean topBorder = true;
        private boolean leftBorder = true;

        private KeyBoardAdapter(String[] text) {
            this.text = text;
        }

        public KeyBoardAdapter setBorder(boolean topBorder, boolean leftBorder) {
            this.topBorder = topBorder;
            this.leftBorder = leftBorder;
            return this;
        }


        @NonNull
        @Override
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.ui_item_keyboard, parent, false), parent);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            holder.key.setText(text[position]);
            holder.top_border.setVisibility(topBorder ? VISIBLE : GONE);
            holder.left_border.setVisibility(leftBorder ? VISIBLE : GONE);
        }

        @Override
        public int getItemCount() {
            return text.length;
        }
    }

    private class ViewHolder extends RecyclerView.ViewHolder {
        private TextView key;
        private View top_border;
        private View left_border;

        private ViewHolder(View itemView, ViewGroup parent) {
            super(itemView);
            int parentHeight = parent.getHeight();
            int parentWidth = parent.getWidth();
            ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
            layoutParams.height = (parentHeight / 4);
            itemView.setLayoutParams(layoutParams);

            top_border = itemView.findViewById(R.id.keyboard_top_border);
            left_border = itemView.findViewById(R.id.keyboard_left_border);

            key = itemView.findViewById(R.id.tv_item_keyboard);
            key.setOnClickListener(view -> {
                String keyValue = ((TextView) view).getText().toString();
                if (keyValue.equals(number[9])) {
                    //清空
                    tvInput.setText("");
                } else if (keyValue.equals(number[11])) {
                    //確認
                    if (onConfirmCallBack != null) {
                        onConfirmCallBack.onCallBack(tvInput.getText().toString());
                    }
                } else {
                    tvInput.append(keyValue);
                }
            });
        }
    }

    public void clearInput(){
        tvInput.setText("");
    }

    public class ItemOffsetDecoration extends RecyclerView.ItemDecoration {

        private int mItemOffset;

        public ItemOffsetDecoration(int itemOffset) {
            mItemOffset = itemOffset;
        }

        public ItemOffsetDecoration(Context context, int itemOffsetId) {
            this(context.getResources().getDimensionPixelSize(itemOffsetId));
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent,
                                   RecyclerView.State state) {
            super.getItemOffsets(outRect, view, parent, state);
            outRect.set(mItemOffset, mItemOffset, mItemOffset, mItemOffset);
        }
    }
}
