package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/25
 * Time: 18:20
 * Use:
 */
public class PurchaseFoodEncodeSn implements Serializable {
    /**
     * 食材編號
     */
    private String encodeFoodNo;
    /**
     * 採購訂單編號
     */
    private String encodeOrderNo;
    /**
     * sn編碼
     */
    private String encodeSnNo;

    public Integer id;
    public long createTime;
    public long updateTime;
    public int createUid;
    public int updateUid;
    public String userName;
    /**
     * 是否新增
     */
    public boolean newAdd = false;
    /**
     * 1未消耗
     */
    public int status = 1;

    public PurchaseFoodEncodeSn() {
    }

    public PurchaseFoodEncodeSn(String encodeSnNo) {
        this.encodeSnNo = encodeSnNo;
    }

    public PurchaseFoodEncodeSn(String encodeFoodNo, String encodeOrderNo, String encodeSnNo) {
        this.encodeFoodNo = encodeFoodNo;
        this.encodeOrderNo = encodeOrderNo;
        this.encodeSnNo = encodeSnNo;
    }

    public String getEncodeFoodNo() {
        return encodeFoodNo;
    }

    public void setEncodeFoodNo(String encodeFoodNo) {
        this.encodeFoodNo = encodeFoodNo;
    }

    public String getEncodeOrderNo() {
        return encodeOrderNo;
    }

    public void setEncodeOrderNo(String encodeOrderNo) {
        this.encodeOrderNo = encodeOrderNo;
    }

    public String getEncodeSnNo() {
        return encodeSnNo;
    }

    public void setEncodeSnNo(String encodeSnNo) {
        this.encodeSnNo = encodeSnNo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PurchaseFoodEncodeSn that = (PurchaseFoodEncodeSn) o;
        return createTime == that.createTime &&
                updateTime == that.updateTime &&
                createUid == that.createUid &&
                updateUid == that.updateUid &&
                newAdd == that.newAdd &&
                status == that.status &&
                Objects.equals(encodeFoodNo, that.encodeFoodNo) &&
                Objects.equals(encodeOrderNo, that.encodeOrderNo) &&
                Objects.equals(encodeSnNo, that.encodeSnNo) &&
                Objects.equals(id, that.id) &&
                Objects.equals(userName, that.userName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(encodeFoodNo, encodeOrderNo, encodeSnNo, id, createTime, updateTime, createUid, updateUid, userName, newAdd, status);
    }
}
